// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

/**
 * Created by minie on 30/6/15.
 * Constants for analytics.
 */

public class CBConstant {

    //Event keys for CBAnalytics
    static final String PAYMENT_INITIATED = "payment_initiated";
    static final String CUSTOM_BROWSER = "CUSTOM_BROWSER";
    static final String NON_CUSTOM_BROWSER = "NON_CUSTOM_BROWSER";
    static final String PASSWORD = "password_click";
    static final String OTP = "otp_click";
    static final String RECEIVED_OTP_DIRECT = "received_otp_direct";
    static final String RECEIVED_OTP_SELECTED = "received_otp_selected";
    static final String RECEIVED_OTP_REGENERATE = "received_otp_regenerate";

    static final String OTP_WEB = "otp_web";

    static final String REGENERATE = "regenerate_click";
    static final String ENTER_MANUALLY = "enter_manually_click";
    static final String APPROVED_OTP = "approved_otp";
    static final String SUCCESS_TRANSACTION = "success_transaction";
    static final String FAILURE_TRANSACTION = "failure_transaction";
    static final String TERMINATE_TRANSACTION = "terminate_transaction";


    //Keys for Device Tracking for transaction
    public static final String SDK_VERSION_NAME = "sdk_version";
    public static final String CB_VERSION_NAME = "cb_version";
    public static final String DEVICE_OS_VERSION = "os_version";
    public static final String NETWORK_INFO = "network_info";
    public static final String NETWORK_STRENGTH="network_strength";
    public static final String DEVICE_RESOLUTION = "resolution";
    public static final String DEVICE_MANUFACTURE="device_manufacturer";
    public static final String DEVICE_MODEL="device_model";
    public static final String MERCHANT_KEY="merchant_key";
    public static final String TRANSACTION_ID="txnid";

    //Event Analyitcs
    public static final String BANK_NAME="bank";
    public static final String PAKAGE_NAME="package_name";
    public static final String KEY="key";
    public static final String VALUE="value";

    //Key for Event CBAnalytics
    public static final String USER_INPUT="user_input";
    public static final String LAST_URL="last_url";
    public static final String CB_STATUS="cb_status";
    public static final String OTP_RECIEVED="otp_received";
    public static final String TRNX_STATUS="trxn_status";

    static final String JANTA_URL="https://jsbeasynet.jsbnet.in";
    static final String JANTA_DOMAIN="jsbeasynet.jsbnet.in";
    static final String PAYU_PREFERENCE = "PayuPreference";
    static final String DEFAULT = "default";
    static final String CARD_TOKEN = "card_token";
    static final String MERCHANT_HASH = "merchant_hash";
    static final String CB_AUTO_APPROVE="auto_approve";
    static final String CB_AUTO_OTP_SELECT="auto_otp_select";

    static final int STORE_ONE_CLICK_HASH_NONE = 0;
    static final int STORE_ONE_CLICK_HASH_SERVER = 1;
    static final int STORE_ONE_CLICK_HASH_MOBILE = 2;

}