/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.Activity;
import android.os.AsyncTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CBAnalytics {
    private static final String TEST_URL = "https://mobiledev.payu.in/merchant/postservice.php?form=2";
    private static final String PRODUCTION_URL = "https://info.payu.in/merchant/postservice.php?form=2";
    private String fileName;
    private static final long TIMER_DELAY = 5000L;
    private static CBAnalytics INSTANCE;
    private final Activity mActivity;
    private String ANALYTICS_URL = "https://info.payu.in/merchant/postservice.php?form=2";
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer = new ArrayList();
    private Timer mTimer;

    public CBAnalytics(Activity activity, String filename) {
        this.mActivity = activity;
        this.fileName = filename;
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (CBAnalytics.this.mIsLocked) {
                }
                CBAnalytics.this.setLock();
                try {
                    FileOutputStream fileOutputStream = CBAnalytics.this.mActivity.openFileOutput(CBAnalytics.this.fileName, 0);
                    int c = CBAnalytics.this.mBuffer.size();
                    for (int i = 0; i < c; ++i) {
                        fileOutputStream.write(((String)CBAnalytics.this.mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                CBAnalytics.this.releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    public static synchronized CBAnalytics getInstance(Activity activity, String fileName) {
        if (INSTANCE == null) {
            INSTANCE = new CBAnalytics(activity, fileName);
        }
        return INSTANCE;
    }

    public void log(final String msg) {
        this.resetTimer();
        if (this.mIsLocked) {
            this.mBuffer.add(msg);
        } else {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... voids) {
                    CBAnalytics.this.setLock();
                    try {
                        int c;
                        JSONObject newobject = new JSONObject(msg);
                        JSONArray jsonArray = new JSONArray();
                        String temp = "";
                        File file = new File(CBAnalytics.this.mActivity.getFilesDir(), CBAnalytics.this.fileName);
                        if (!file.exists()) {
                            CBAnalytics.this.mActivity.openFileOutput(CBAnalytics.this.fileName, 0);
                        }
                        FileInputStream fileInputStream = CBAnalytics.this.mActivity.openFileInput(CBAnalytics.this.fileName);
                        while ((c = fileInputStream.read()) != -1) {
                            temp = temp + Character.toString((char)c);
                        }
                        jsonArray = temp.equalsIgnoreCase("") ? new JSONArray() : new JSONArray(temp);
                        fileInputStream.close();
                        FileOutputStream fileOutputStream = CBAnalytics.this.mActivity.openFileOutput(CBAnalytics.this.fileName, 0);
                        jsonArray.put(jsonArray.length(), (Object)newobject);
                        fileOutputStream.write(jsonArray.toString().getBytes());
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        CBAnalytics.this.mBuffer.add(msg);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    CBAnalytics.this.releaseLock();
                    return null;
                }
            }.execute((Object[])new Void[]{null, null, null});
        }
    }

    private void resetTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (CBAnalytics.this.mIsLocked) {
                }
                CBAnalytics.this.setLock();
                String temp = "";
                try {
                    int c;
                    File file = new File(CBAnalytics.this.mActivity.getFilesDir(), CBAnalytics.this.fileName);
                    if (!file.exists()) {
                        CBAnalytics.this.mActivity.openFileOutput(CBAnalytics.this.fileName, 0);
                    }
                    FileInputStream fileInputStream = CBAnalytics.this.mActivity.openFileInput(CBAnalytics.this.fileName);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char)c);
                    }
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    block57: {
                        try {
                            int i;
                            JSONArray tempJsonArray = new JSONArray(temp);
                            JSONArray bufferJsonArray = new JSONArray(CBAnalytics.this.mBuffer.toString());
                            if (bufferJsonArray.length() > 0) {
                                for (int i2 = 0; i2 < bufferJsonArray.length(); ++i2) {
                                    tempJsonArray.put(bufferJsonArray.get(i2));
                                }
                                CBAnalytics.this.mBuffer = new ArrayList();
                            }
                            if (tempJsonArray.length() <= 0) break block57;
                            String postData = "command=sdkWsNew&var1=" + tempJsonArray.toString();
                            byte[] postParamsByte = postData.getBytes();
                            URL url = new URL(CBAnalytics.this.ANALYTICS_URL);
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
                            conn.setDoOutput(true);
                            conn.getOutputStream().write(postParamsByte);
                            int responseCode = conn.getResponseCode();
                            InputStream responseInputStream = conn.getInputStream();
                            StringBuffer responseStringBuffer = new StringBuffer();
                            byte[] byteContainer = new byte[1024];
                            while ((i = responseInputStream.read(byteContainer)) != -1) {
                                responseStringBuffer.append(new String(byteContainer, 0, i));
                            }
                            if (responseCode == 200) {
                                try {
                                    JSONObject jsonObject = new JSONObject(responseStringBuffer.toString());
                                    if (jsonObject.has("status") && jsonObject.getString("status").equals("1")) {
                                        CBAnalytics.this.mActivity.deleteFile(CBAnalytics.this.fileName);
                                        break block57;
                                    }
                                    try {
                                        FileOutputStream fileOutputStream = CBAnalytics.this.mActivity.openFileOutput(CBAnalytics.this.fileName, 0);
                                        fileOutputStream.write(temp.getBytes());
                                        fileOutputStream.close();
                                        break block57;
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    try {
                                        FileOutputStream fileOutputStream = CBAnalytics.this.mActivity.openFileOutput(CBAnalytics.this.fileName, 0);
                                        fileOutputStream.write(temp.getBytes());
                                        fileOutputStream.close();
                                        break block57;
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                break block57;
                            }
                            try {
                                FileOutputStream fileOutputStream = CBAnalytics.this.mActivity.openFileOutput(CBAnalytics.this.fileName, 0);
                                fileOutputStream.write(temp.getBytes());
                                fileOutputStream.close();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        catch (ProtocolException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (CBAnalytics.this.mBuffer.size() > 0) {
                    CBAnalytics.this.resetTimer();
                }
                CBAnalytics.this.releaseLock();
            }
        }, 5000L);
    }

    synchronized void setLock() {
        this.mIsLocked = true;
    }

    synchronized void releaseLock() {
        this.mIsLocked = false;
    }
}

