/*
 * Decompiled with CFR 0.152.
 */
package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.Build;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import java.util.StringTokenizer;

public class CBUtil {
    public static boolean getbooleanSharedPreference(String key, Activity mActivity) {
        SharedPreferences sharedPreferences = mActivity.getSharedPreferences("com.payu", 0);
        return sharedPreferences.getBoolean(key, false);
    }

    public static void setBooleanSharedPreference(String key, boolean value, Activity mActivity) {
        SharedPreferences.Editor editor = mActivity.getSharedPreferences("com.payu", 0).edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    static boolean isNetworkAvailable(Context context) {
        NetworkInfo[] netInfo;
        boolean haveConnectedWifi = false;
        boolean haveConnectedMobile = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        for (NetworkInfo ni : netInfo = cm.getAllNetworkInfo()) {
            if (ni.getTypeName().equalsIgnoreCase("WIFI") && ni.isConnected()) {
                haveConnectedWifi = true;
            }
            if (!ni.getTypeName().equalsIgnoreCase("MOBILE") || !ni.isConnected()) continue;
            haveConnectedMobile = true;
        }
        return haveConnectedWifi || haveConnectedMobile;
    }

    static String getDeviceDensity(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi + "";
    }

    static void getDownloadSpeed(Activity activity) {
        String[] testing = new String[2];
        long BeforeTime = System.currentTimeMillis();
        long TotalTxBeforeTest = TrafficStats.getTotalTxBytes();
        long TotalRxBeforeTest = TrafficStats.getTotalRxBytes();
        long TotalTxAfterTest = TrafficStats.getTotalTxBytes();
        long TotalRxAfterTest = TrafficStats.getTotalRxBytes();
        long AfterTime = System.currentTimeMillis();
        double TimeDifference = AfterTime - BeforeTime;
        double rxDiff = TotalRxAfterTest - TotalRxBeforeTest;
        double txDiff = TotalTxAfterTest - TotalTxBeforeTest;
        if (rxDiff != 0.0 && txDiff != 0.0) {
            double rxBPS = rxDiff / (TimeDifference / 1000.0);
            double txBPS = txDiff / (TimeDifference / 1000.0);
            testing[0] = String.valueOf(rxBPS) + "bps. Total rx = " + rxDiff;
            testing[1] = String.valueOf(txBPS) + "bps. Total tx = " + txDiff;
        } else {
            testing[0] = "No uploaded or downloaded bytes.";
        }
    }

    static void setAlpha(float alpha, View view) {
        if (Build.VERSION.SDK_INT < 11) {
            AlphaAnimation animation = new AlphaAnimation(alpha, alpha);
            animation.setDuration(10L);
            animation.setFillAfter(true);
            view.startAnimation((Animation)animation);
        } else {
            view.setAlpha(alpha);
        }
    }

    static String getNetworkStatus(Activity activity) {
        try {
            if (null != activity && !activity.isFinishing()) {
                ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
                NetworkInfo info = cm.getActiveNetworkInfo();
                if (info == null || !info.isConnected()) {
                    return "Not connected";
                }
                if (info.getType() == 1) {
                    return "WIFI";
                }
                if (info.getType() == 0) {
                    int networkType = info.getSubtype();
                    switch (networkType) {
                        case 1: {
                            return "GPRS";
                        }
                        case 2: {
                            return "EDGE";
                        }
                        case 4: {
                            return "CDMA";
                        }
                        case 7: 
                        case 11: {
                            return "2G";
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: {
                            return "HSPA";
                        }
                        case 12: 
                        case 14: 
                        case 15: {
                            return "3G";
                        }
                        case 13: {
                            return "4G";
                        }
                    }
                    return "?";
                }
            }
        }
        catch (Exception e) {
            return "?";
        }
        return "?";
    }

    static int getNetworkStrenght(Activity activity) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)activity.getSystemService("connectivity");
            NetworkInfo[] netInfo = connectivityManager.getAllNetworkInfo();
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            int strength = 0;
            for (NetworkInfo networkInfo : netInfo) {
                if (Build.VERSION.SDK_INT < 18 || !networkInfo.getTypeName().equalsIgnoreCase("MOBILE") || !networkInfo.isConnected()) continue;
                for (CellInfo info : telephonyManager.getAllCellInfo()) {
                    if (!info.isRegistered()) continue;
                    if (info instanceof CellInfoGsm) {
                        CellSignalStrengthGsm gsm = ((CellInfoGsm)info).getCellSignalStrength();
                        strength = gsm.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoCdma) {
                        CellSignalStrengthCdma cdma = ((CellInfoCdma)info).getCellSignalStrength();
                        strength = cdma.getDbm();
                        continue;
                    }
                    if (info instanceof CellInfoLte) {
                        CellSignalStrengthLte lte = ((CellInfoLte)info).getCellSignalStrength();
                        strength = lte.getDbm();
                        continue;
                    }
                    if (!(info instanceof CellInfoWcdma)) continue;
                    CellSignalStrengthWcdma wcdma = ((CellInfoWcdma)info).getCellSignalStrength();
                    strength = wcdma.getDbm();
                }
            }
            return strength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    static void setStringSharedPreference(Activity activity, String key, String url) {
        String str = CBUtil.getStringSharedPreference(activity, key);
        if (str.equalsIgnoreCase("")) {
            str = url;
        } else if (str.indexOf("||") == -1) {
            str = str + "||" + url;
        } else {
            StringTokenizer st = new StringTokenizer(str, "||");
            st.nextToken();
            str = st.nextToken() + "||" + url;
        }
        SharedPreferences.Editor sharedPreferencesEditor = activity.getSharedPreferences("com.payu.custombrowser", 0).edit();
        sharedPreferencesEditor.putString(key, str);
        sharedPreferencesEditor.commit();
    }

    static String getStringSharedPreference(Activity activity, String key) {
        SharedPreferences sharedPreferences = activity.getSharedPreferences("com.payu.custombrowser", 0);
        return sharedPreferences.getString(key, "");
    }

    static void delSharedLastURL(Activity activity, String key) {
        try {
            SharedPreferences.Editor sharedPreferencesEditor = activity.getSharedPreferences("com.payu.custombrowser", 0).edit();
            sharedPreferencesEditor.remove(key);
            sharedPreferencesEditor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String updateLastUrl(String lastUrl) {
        block6: {
            try {
                if (!lastUrl.contains("||")) {
                    if (lastUrl.length() > 128) {
                        return lastUrl.substring(0, 127);
                    }
                    break block6;
                }
                StringTokenizer st = new StringTokenizer(lastUrl, "||");
                String firstURl = st.nextToken();
                String secondUrl = st.nextToken();
                if (firstURl.length() > 128) {
                    firstURl = firstURl.substring(0, 125);
                }
                if (secondUrl.length() > 128) {
                    secondUrl = secondUrl.substring(0, 125);
                }
                return firstURl + "||" + secondUrl;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return "";
    }

    static void storeInSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public String getFromSharedPreferences(Context context, String key) {
        return this.getFromSharedPreferences(context, key, "default");
    }

    public String getFromSharedPreferences(Context context, String key, String defaultValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        return sharedPreferences.getString(key, defaultValue);
    }

    public void removeFromSharedPreferences(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("PayuPreference", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }
}

