package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import android.widget.Toast;

import org.json.JSONObject;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by minie on 10/9/15.
 */
public class CBReadSMS {
    private  Activity activity;
    private  JSONObject mBankJS;
    private String mPassword;
    CBReadSMS(Activity activity, String timefrom, JSONObject mBankJS){
        this.activity=activity;
        this.mBankJS=mBankJS;
        Uri myMessage = Uri.parse("content://sms/inbox");
        String columns[] = new String[] { "person", "address", "body",
                "date", "status" };
      //  1442415191190
        String sortOrder = "date DESC";
        //String filter="date BETWEEN "+ timeTo+ " AND " +"1442000000000";
        String filter="date>=" + timefrom;
        Cursor c = activity.getContentResolver().query(myMessage, columns, filter, null,
                sortOrder);
        getSmsLogs(c, activity);
    }

    public String getmPassword(){
        return mPassword;
    }
    public void getSmsLogs(Cursor c, Context con) {
        try {
            if (c.moveToFirst()) {
                do {
                    Toast.makeText(activity,"count of message =="+c.getCount(),Toast.LENGTH_SHORT).show();
                    if (c.getString(c.getColumnIndexOrThrow("address")) == null) {
                        c.moveToNext();
                        continue;
                    }
                    String Number = c.getString(
                            c.getColumnIndexOrThrow("address")).toString();

                    String date = c.getString(c.getColumnIndexOrThrow("date"))
                            .toString();
                    String body = c.getString(c.getColumnIndexOrThrow("body"))
                            .toString();

                   Matcher match = Pattern.compile(mBankJS.getString(activity.getString(R.string.cb_detect_otp)), Pattern.CASE_INSENSITIVE).matcher(body);
                    if (match.find()) {
                        // otp sms
                        match = Pattern.compile(mBankJS.getString(activity.getString(R.string.cb_find_otp)), Pattern.CASE_INSENSITIVE).matcher(body);
                        if (match.find()) {
                            mPassword = match.group(1).replaceAll("[^0-9]", "");
                            if(mPassword!=null)
                                break;
                        }
                    }
                } while (c.moveToNext());

            }
            c.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
