// The MIT License (MIT)
//
// Copyright (c) 2014-2015 PayU India
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package com.payu.custombrowser;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by amitkumar on 16/01/15.
 *
 * Helps payu to keep track of user interactions with bank page and more.
 * For later fix: make it as singleton.
 */
class CBAnalytics {

    private static final String TEST_URL = "https://mobiletest.payu.in/merchant/postservice.php";
    private static final String PRODUCTION_URL = "https://info.payu.in/merchant/postservice.php";
    private static final String FILE_NAME = "local_cache";
    private static final long TIMER_DELAY = 5000;
    private static CBAnalytics INSTANCE;
    private final Activity mActivity;
    private String ANALYTICS_URL = Bank.DEBUG ? TEST_URL : PRODUCTION_URL;
    private boolean mIsLocked = false;
    private ArrayList<String> mBuffer = new ArrayList<String>();
    private Timer mTimer;


    /**
     * Constructor
     * @param activity
     */
    public CBAnalytics(Activity activity) {
        mActivity = activity;
        final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler _unCaughtExceptionHandler = new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                while (mIsLocked) ;
                setLock();
                try {
                    FileOutputStream fileOutputStream = mActivity.openFileOutput(FILE_NAME, Context.MODE_PRIVATE);
                    int c = mBuffer.size();
                    for (int i = 0; i < c; i++) {
                        fileOutputStream.write((mBuffer.get(i) + "\r\n").getBytes());
                    }
                    fileOutputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                releaseLock();
                defaultUEH.uncaughtException(thread, ex);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(_unCaughtExceptionHandler);
    }

    /**
     * keep only one object
     * @param activity
     * @return CBAnalytics instance.
     */
    public static synchronized CBAnalytics getInstance(Activity activity) {
        if (INSTANCE == null) {
            INSTANCE = new CBAnalytics(activity);
        }
        return INSTANCE;
    }

    /**
     * Adding log information to a local file.
     * @param msg
     */
    public void log(final String msg) {
        resetTimer();
        if (mIsLocked) {
            mBuffer.add(msg);
        } else {
            new AsyncTask<Void, Void, Void>() {
                @Override
                protected Void doInBackground(Void... voids) {
                    setLock();
                    try {
                        int c;
                        String temp = "";
                        File file = new File(mActivity.getFilesDir(), FILE_NAME);
                        if (!file.exists()) { // create the file if not created yet.
                            mActivity.openFileOutput(FILE_NAME, Context.MODE_PRIVATE);
                        }
                        FileInputStream fileInputStream = mActivity.openFileInput(FILE_NAME);
                        while ((c = fileInputStream.read()) != -1) {
                            temp = temp + Character.toString((char) c);
                        }
                        fileInputStream.close();
                        FileOutputStream fileOutputStream = mActivity.openFileOutput(FILE_NAME, Context.MODE_PRIVATE);
                        fileOutputStream.write((temp + msg + "\r\n").getBytes());
                        fileOutputStream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                        mBuffer.add(msg);
                    }
                    releaseLock();
                    return null;
                }
            }.execute(null, null, null);
        }
    }


    /**
     * Open file and read the content.
     * Send the contents to payu server
     * command should be sdkWs and var1 should be the actual data.
     */
    private void resetTimer() {
        if (mTimer != null) {
            mTimer.cancel();
        }
        mTimer = new Timer();
        mTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                while (mIsLocked) ;
                setLock();
                String temp = "";
                int c;
                try {
                    File file = new File(mActivity.getFilesDir(), FILE_NAME);
                    if (!file.exists()) { // create the file if not created yet.
                        mActivity.openFileOutput(FILE_NAME, Context.MODE_PRIVATE);
                    }
                    FileInputStream fileInputStream = mActivity.openFileInput(FILE_NAME);
                    while ((c = fileInputStream.read()) != -1) {
                        temp = temp + Character.toString((char) c);

                    }
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    c = mBuffer.size();
                    while (c > 0) {
                        c--;
                        temp = temp + mBuffer.get(c) + "\r\n";
                        if (c >= 0 && mBuffer.size() > c)
                            mBuffer.remove(c);
                    }
                    temp = temp.trim();
                    if (temp.length() > 0) {
                        // lets prepare data
                        String postData = "command=sdkWs&var1=" + temp;
                        try {

                            byte[] postParamsByte = postData.getBytes("UTF-8");
                            URL url = new URL(ANALYTICS_URL);
                            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                            conn.setRequestMethod("POST");
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
                            conn.setDoOutput(true);
                            conn.getOutputStream().write(postParamsByte);
                            int responseCode = conn.getResponseCode();

                            InputStream responseInputStream = conn.getInputStream();
                            StringBuffer responseStringBuffer = new StringBuffer();
                            byte[] byteContainer = new byte[1024];
                            for (int i; (i = responseInputStream.read(byteContainer)) != -1; ) {
                                responseStringBuffer.append(new String(byteContainer, 0, i));
                            }

                            if (responseCode == HttpURLConnection.HTTP_OK) {
                                mActivity.deleteFile(FILE_NAME);
                            } else {
                                // Do the required operation. here.
                                try {
                                    FileOutputStream fileOutputStream = mActivity.openFileOutput(FILE_NAME, Context.MODE_PRIVATE);
                                    fileOutputStream.write(temp.getBytes());
                                    fileOutputStream.close();
                                } catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }

                        } catch (MalformedURLException e) {
                            e.printStackTrace();

                        } catch (ProtocolException e) {
                            e.printStackTrace();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (mBuffer.size() > 0) {
                    resetTimer();
                }
                releaseLock();
            }
        }, TIMER_DELAY);
    }

    synchronized void setLock() {
        mIsLocked = true;
    }

    synchronized void releaseLock() {
        mIsLocked = false;
    }

}
