/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgentHeader {
    private String productId;
    private String productVersion;
    private static final String JAVAHEADER;
    private static final String OSHEADER;

    public UserAgentHeader(String productId, String productVersion) {
        this.productId = productId != null && productId.trim().length() > 0 ? productId : "";
        this.productVersion = productVersion != null && productVersion.trim().length() > 0 ? productVersion : "";
    }

    public Map<String, String> getHeader() {
        HashMap<String, String> userAgentMap = new HashMap<String, String>();
        userAgentMap.put("User-Agent", this.formUserAgentHeader());
        return userAgentMap;
    }

    private String formUserAgentHeader() {
        String header = null;
        StringBuilder stringBuilder = new StringBuilder("PayPalSDK/" + this.productId + " " + this.productVersion + " ");
        stringBuilder.append("(").append(JAVAHEADER);
        String osVersion = OSHEADER;
        if (osVersion.length() > 0) {
            stringBuilder.append(";").append(osVersion);
        }
        stringBuilder.append(")");
        header = stringBuilder.toString();
        return header;
    }

    static {
        StringBuilder javaVersion = new StringBuilder("lang=Java");
        if (System.getProperty("java.version") != null && System.getProperty("java.version").length() > 0) {
            javaVersion.append(";v=").append(System.getProperty("java.version"));
        }
        if (System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").length() > 0) {
            javaVersion.append(";bit=");
            if (System.getProperty("java.vm.name").contains("Client")) {
                javaVersion.append("32");
            } else {
                javaVersion.append("64");
            }
        }
        JAVAHEADER = javaVersion.toString();
        StringBuilder osVersion = new StringBuilder();
        if (System.getProperty("os.name") != null && System.getProperty("os.name").length() > 0) {
            osVersion.append("os=");
            osVersion.append(System.getProperty("os.name").replace(' ', '_'));
        } else {
            osVersion.append("os=");
        }
        if (System.getProperty("os.version") != null && System.getProperty("os.version").length() > 0) {
            osVersion.append(" " + System.getProperty("os.version").replace(' ', '_'));
        }
        OSHEADER = osVersion.toString();
    }
}

