/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.paypal.base.APICallPreHandler;
import com.paypal.base.SDKUtil;
import com.paypal.base.SDKVersion;
import com.paypal.base.codec.binary.Base64;
import com.paypal.base.credential.ICredential;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.util.UserAgentHeader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTAPICallPreHandler
implements APICallPreHandler {
    private Map<String, String> configurationMap = null;
    private URL url;
    private String authorizationToken;
    private String resourcePath;
    private String requestId;
    private Map<String, String> headersMap;
    private String payLoad;
    private SDKVersion sdkVersion;

    public RESTAPICallPreHandler(Map<String, String> configurationMap) {
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
    }

    public RESTAPICallPreHandler(Map<String, String> configurationMap, Map<String, String> headersMap) {
        this(configurationMap);
        this.headersMap = headersMap == null ? Collections.emptyMap() : headersMap;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setPayLoad(String payLoad) {
        this.payLoad = payLoad;
    }

    public void setSdkVersion(SDKVersion sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.getProcessedHeaderMap();
    }

    @Override
    public String getPayLoad() {
        return this.getProcessedPayLoad();
    }

    @Override
    public String getEndPoint() {
        return this.getProcessedEndPoint();
    }

    @Override
    public ICredential getCredential() {
        return null;
    }

    @Override
    public void validate() throws ClientActionRequiredException {
    }

    public URL getBaseURL() throws MalformedURLException {
        if (this.url == null) {
            String urlString = this.configurationMap.get("service.EndPoint");
            if (urlString == null || urlString.length() <= 0) {
                String mode = this.configurationMap.get("mode");
                if ("sandbox".equalsIgnoreCase(mode)) {
                    urlString = "https://api.sandbox.paypal.com/";
                } else if ("live".equalsIgnoreCase(mode)) {
                    urlString = "https://api.paypal.com/";
                } else {
                    throw new MalformedURLException("service.EndPoint not set (OR) mode not configured to sandbox/live ");
                }
            }
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            this.url = new URL(urlString);
        }
        return this.url;
    }

    public void setUrl(String urlString) throws MalformedURLException {
        if (urlString != null && urlString.length() > 0) {
            String uString = urlString.endsWith("/") ? urlString : urlString + "/";
            this.url = new URL(uString);
        } else {
            this.url = this.getBaseURL();
        }
    }

    protected Map<String, String> formUserAgentHeader() {
        UserAgentHeader userAgentHeader = new UserAgentHeader(this.sdkVersion != null ? this.sdkVersion.getSDKId() : null, this.sdkVersion != null ? this.sdkVersion.getSDKVersion() : null);
        return userAgentHeader.getHeader();
    }

    private String getClientID() {
        return this.configurationMap.get("clientId");
    }

    private String getClientSecret() {
        return this.configurationMap.get("clientSecret");
    }

    private String encodeToBase64(String clientID, String clientSecret) throws UnsupportedEncodingException {
        String base64ClientID = this.generateBase64String(clientID + ":" + clientSecret);
        return base64ClientID;
    }

    private String generateBase64String(String clientID) throws UnsupportedEncodingException {
        String base64ClientID = null;
        byte[] encoded = null;
        encoded = Base64.encodeBase64(clientID.getBytes("UTF-8"));
        base64ClientID = new String(encoded, "UTF-8");
        return base64ClientID;
    }

    protected String getProcessedEndPoint() {
        String endPoint = null;
        try {
            endPoint = this.getBaseURL().toURI().resolve(this.resourcePath).toString();
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return endPoint;
    }

    protected Map<String, String> getProcessedHeaderMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.authorizationToken != null && this.authorizationToken.trim().length() > 0) {
            headers.put("Authorization", this.authorizationToken);
        } else if (this.getClientID() != null && this.getClientID().trim().length() > 0 && this.getClientSecret() != null && this.getClientSecret().trim().length() > 0) {
            try {
                headers.put("Authorization", "Basic " + this.encodeToBase64(this.getClientID(), this.getClientSecret()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.requestId != null && this.requestId.length() > 0) {
            headers.put("PayPal-Request-Id", this.requestId);
        }
        headers.putAll(this.formUserAgentHeader());
        if (this.headersMap != null && this.headersMap.size() > 0) {
            headers.putAll(this.headersMap);
        }
        if (!headers.containsKey("Content-Type")) {
            headers.put("Content-Type", "application/json");
        }
        return headers;
    }

    protected String getProcessedPayLoad() {
        return this.payLoad;
    }
}

