/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.HttpConfiguration;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.exception.HttpErrorException;
import com.paypal.base.exception.InvalidResponseDataException;
import com.paypal.base.exception.SSLConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpConnection {
    private static final Logger log = LogManager.getLogger(HttpConnection.class);
    protected HttpConfiguration config;
    protected HttpURLConnection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String url, String payload, Map<String, String> headers) throws InvalidResponseDataException, IOException, InterruptedException, HttpErrorException, ClientActionRequiredException {
        String successResponse = "";
        String errorResponse = "";
        int responsecode = -1;
        BufferedReader reader = null;
        OutputStreamWriter writer = null;
        this.connection.setRequestProperty("Content-Length", "" + payload.trim().length());
        if (headers != null) {
            log.debug("curl command: ");
            log.debug("curl -v '" + this.connection.getURL().toString() + "' \\");
            this.setHttpHeaders(headers);
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                log.debug("-H \"" + key + ": " + value + "\" \\");
            }
            log.debug("-d '" + payload + "'");
        }
        try {
            Exception lastException = null;
            int retry = 0;
            while (true) {
                try {
                    if ("POST".equalsIgnoreCase(this.connection.getRequestMethod()) || "PUT".equalsIgnoreCase(this.connection.getRequestMethod()) || "PATCH".equalsIgnoreCase(this.connection.getRequestMethod())) {
                        writer = new OutputStreamWriter(this.connection.getOutputStream(), Charset.forName("UTF-8"));
                        writer.write(payload);
                        writer.flush();
                    }
                    responsecode = this.connection.getResponseCode();
                    reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
                    if (responsecode < 200 || responsecode >= 300) {
                        successResponse = this.read(reader);
                        throw new ClientActionRequiredException("Response Code : " + responsecode + " with response : " + successResponse);
                    }
                    successResponse = this.read(reader);
                    log.debug("Response : " + successResponse);
                }
                catch (IOException e) {
                    lastException = e;
                    try {
                        responsecode = this.connection.getResponseCode();
                        if (this.connection.getErrorStream() != null) {
                            reader = new BufferedReader(new InputStreamReader(this.connection.getErrorStream(), "UTF-8"));
                            errorResponse = this.read(reader);
                            log.error("Error code : " + responsecode + " with response : " + errorResponse);
                        }
                        if (errorResponse == null || errorResponse.length() == 0) {
                            errorResponse = e.getMessage();
                        }
                        if (responsecode <= 500) {
                            throw new HttpErrorException(responsecode, errorResponse, "Error code : " + responsecode + " with response : " + errorResponse, e);
                        }
                    }
                    catch (HttpErrorException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        lastException = ex;
                        log.error("Caught exception while handling error response", (Throwable)ex);
                    }
                    if (++retry <= 0) continue;
                    log.error(" Retry  No : " + retry + "...");
                    Thread.sleep(this.config.getRetryDelay());
                    if (retry < this.config.getMaxRetry()) continue;
                }
                break;
            }
            if (successResponse.trim().length() <= 0 && (responsecode < 200 || responsecode >= 300)) {
                throw new HttpErrorException("retry fails..  check log for more information", lastException);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            finally {
                reader = null;
                writer = null;
            }
        }
        return successResponse;
    }

    public abstract void setupClientSSL(String var1, String var2) throws SSLConfigurationException;

    public abstract void createAndconfigureHttpConnection(HttpConfiguration var1) throws IOException;

    protected String read(BufferedReader reader) throws IOException {
        String inputLine = "";
        StringBuilder response = new StringBuilder();
        while ((inputLine = reader.readLine()) != null) {
            response.append(inputLine);
        }
        return response.toString();
    }

    protected void setHttpHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> pairs : headers.entrySet()) {
            String key = pairs.getKey();
            String value = pairs.getValue();
            this.connection.setRequestProperty(key, value);
        }
    }
}

