/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.metrics.guice;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.palominolabs.metrics.guice.DeclaredMethodsTypeListener;
import com.palominolabs.metrics.guice.MetricNamer;
import com.palominolabs.metrics.guice.TimedInterceptor;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;

public class TimedListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;

    public TimedListener(MetricRegistry metricRegistry, MetricNamer metricNamer) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        Timed annotation = method.getAnnotation(Timed.class);
        if (annotation != null) {
            Timer timer = this.metricRegistry.timer(this.metricNamer.getNameForTimed(method, annotation));
            return new TimedInterceptor(timer);
        }
        return null;
    }
}

