/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.nestedscrollcoordinatorlayout;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@CoordinatorLayout.DefaultBehavior(value=CoordinatorLayout.Behavior.class)
public class NestedScrollCoordinatorLayout
extends CoordinatorLayout
implements NestedScrollingChild {
    private static final String TAG = NestedScrollCoordinatorLayout.class.getSimpleName();
    public static final int PASS_MODE_BOTH = 0;
    public static final int PASS_MODE_PARENT_FIRST = 1;
    private NestedScrollingChildHelper helper;
    private DummyBehavior dummyBehavior;

    public NestedScrollCoordinatorLayout(Context context) {
        super(context);
        this.i();
    }

    public NestedScrollCoordinatorLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.i();
    }

    public NestedScrollCoordinatorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.i();
    }

    private void i() {
        this.helper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        View dummyView = new View(this.getContext());
        this.dummyBehavior = new DummyBehavior();
        ViewCompat.setElevation((View)dummyView, (float)ViewCompat.getElevation((View)this));
        ViewCompat.setFitsSystemWindows((View)dummyView, (boolean)false);
        CoordinatorLayout.LayoutParams params = new CoordinatorLayout.LayoutParams(-1, -1);
        params.setBehavior((CoordinatorLayout.Behavior)this.dummyBehavior);
        this.addView(dummyView, (ViewGroup.LayoutParams)params);
    }

    public void setPassMode(int mode) {
        if (this.dummyBehavior != null) {
            this.dummyBehavior.setPassMode(mode);
        }
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.helper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.helper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.helper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.helper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.helper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, @Nullable @Size(value=2L) int[] offsetInWindow) {
        return this.helper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, @Nullable @Size(value=2L) int[] consumed, @Nullable @Size(value=2L) int[] offsetInWindow) {
        return this.helper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.helper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.helper.dispatchNestedPreFling(velocityX, velocityY);
    }

    private static class DummyBehavior<DummyView extends View>
    extends CoordinatorLayout.Behavior<DummyView> {
        private int mode = 0;
        private final int[] cache = new int[2];

        DummyBehavior() {
        }

        void setPassMode(int mode) {
            this.mode = mode;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, DummyView child, View directTargetChild, View target, int nestedScrollAxes) {
            NestedScrollCoordinatorLayout sheet = (NestedScrollCoordinatorLayout)coordinatorLayout;
            return sheet.startNestedScroll(nestedScrollAxes);
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, DummyView child, View target) {
            NestedScrollCoordinatorLayout sheet = (NestedScrollCoordinatorLayout)coordinatorLayout;
            sheet.stopNestedScroll();
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, DummyView child, View target, int dx, int dy, int[] consumed) {
            NestedScrollCoordinatorLayout sheet = (NestedScrollCoordinatorLayout)coordinatorLayout;
            if (this.mode == 1) {
                sheet.dispatchNestedPreScroll(dx, dy, consumed, null);
            } else if (this.mode == 0) {
                this.cache[0] = consumed[0];
                this.cache[1] = consumed[1];
                sheet.dispatchNestedPreScroll(dx, dy, this.cache, null);
            }
        }

        public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, DummyView child, View target, float velocityX, float velocityY) {
            NestedScrollCoordinatorLayout sheet = (NestedScrollCoordinatorLayout)coordinatorLayout;
            boolean s = sheet.dispatchNestedPreFling(velocityX, velocityY);
            if (this.mode == 1) {
                return s;
            }
            return false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PassMode {
    }
}

