/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video.encoding;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.video.encoding.EncoderThread;
import com.otaliastudios.cameraview.video.encoding.MediaEncoder;
import com.otaliastudios.cameraview.video.encoding.MediaEncoderEngine;
import com.otaliastudios.cameraview.video.encoding.VideoConfig;
import java.io.IOException;

@RequiresApi(api=18)
abstract class VideoMediaEncoder<C extends VideoConfig>
extends MediaEncoder {
    private static final String TAG = VideoMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    protected C mConfig;
    protected Surface mSurface;
    protected int mFrameNumber = -1;

    VideoMediaEncoder(@NonNull C config) {
        super("VideoEncoder");
        this.mConfig = config;
    }

    @Override
    @EncoderThread
    protected void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        MediaFormat format = MediaFormat.createVideoFormat((String)((VideoConfig)this.mConfig).mimeType, (int)((VideoConfig)this.mConfig).width, (int)((VideoConfig)this.mConfig).height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", ((VideoConfig)this.mConfig).bitRate);
        format.setInteger("frame-rate", ((VideoConfig)this.mConfig).frameRate);
        format.setInteger("i-frame-interval", 2);
        format.setInteger("rotation-degrees", ((VideoConfig)this.mConfig).rotation);
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)((VideoConfig)this.mConfig).mimeType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaCodec.configure(format, null, null, 1);
        this.mSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
    }

    @Override
    @EncoderThread
    protected void onStart() {
        this.mFrameNumber = 0;
    }

    @Override
    @EncoderThread
    protected void onStop() {
        LOG.i("onStop", "setting mFrameNumber to 1 and signaling the end of input stream.");
        this.mFrameNumber = -1;
        this.mMediaCodec.signalEndOfInputStream();
        this.drainOutput(true);
    }

    @Override
    protected int getEncodedBitRate() {
        return ((VideoConfig)this.mConfig).bitRate;
    }
}

