/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video.encoding;

import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.internal.egl.EglCore;
import com.otaliastudios.cameraview.internal.egl.EglViewport;
import com.otaliastudios.cameraview.internal.egl.EglWindowSurface;
import com.otaliastudios.cameraview.internal.utils.Pool;
import com.otaliastudios.cameraview.video.encoding.EncoderThread;
import com.otaliastudios.cameraview.video.encoding.MediaEncoderEngine;
import com.otaliastudios.cameraview.video.encoding.TextureConfig;
import com.otaliastudios.cameraview.video.encoding.VideoMediaEncoder;

@RequiresApi(api=18)
public class TextureMediaEncoder
extends VideoMediaEncoder<TextureConfig> {
    private static final String TAG = TextureMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    public static final String FRAME_EVENT = "frame";
    private int mTransformRotation;
    private EglCore mEglCore;
    private EglWindowSurface mWindow;
    private EglViewport mViewport;
    private Pool<Frame> mFramePool = new Pool<Frame>(100, new Pool.Factory<Frame>(){

        @Override
        public Frame create() {
            return new Frame();
        }
    });

    public TextureMediaEncoder(@NonNull TextureConfig config) {
        super(config.copy());
    }

    @NonNull
    public Frame acquireFrame() {
        if (this.mFramePool.isEmpty()) {
            throw new RuntimeException("Need more frames than this! Please increase the pool size.");
        }
        return this.mFramePool.get();
    }

    @Override
    @EncoderThread
    protected void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        this.mTransformRotation = ((TextureConfig)this.mConfig).rotation;
        ((TextureConfig)this.mConfig).rotation = 0;
        super.onPrepare(controller, maxLengthMillis);
        this.mEglCore = new EglCore(((TextureConfig)this.mConfig).eglContext, 1);
        this.mWindow = new EglWindowSurface(this.mEglCore, this.mSurface, true);
        this.mWindow.makeCurrent();
        this.mViewport = new EglViewport();
    }

    @Override
    @EncoderThread
    protected void onEvent(@NonNull String event, @Nullable Object data) {
        if (!event.equals(FRAME_EVENT)) {
            return;
        }
        Frame frame = (Frame)data;
        if (frame == null) {
            throw new IllegalArgumentException("Got null frame for FRAME_EVENT.");
        }
        if (frame.timestamp == 0L) {
            this.mFramePool.recycle(frame);
            return;
        }
        if (this.mFrameNumber < 0) {
            this.mFramePool.recycle(frame);
            return;
        }
        ++this.mFrameNumber;
        if (this.mFrameNumber == 1) {
            this.notifyFirstFrameMillis(frame.timestampMillis);
        }
        LOG.i("onEvent", "frameNumber:", this.mFrameNumber, "timestamp:", frame.timestamp, "- draining.");
        this.drainOutput(false);
        LOG.i("onEvent", "frameNumber:", this.mFrameNumber, "timestamp:", frame.timestamp, "- drawing.");
        float[] transform = frame.transform;
        float[] overlayTransform = frame.overlayTransform;
        float scaleX = ((TextureConfig)this.mConfig).scaleX;
        float scaleY = ((TextureConfig)this.mConfig).scaleY;
        float scaleTranslX = (1.0f - scaleX) / 2.0f;
        float scaleTranslY = (1.0f - scaleY) / 2.0f;
        Matrix.translateM((float[])transform, (int)0, (float)scaleTranslX, (float)scaleTranslY, (float)0.0f);
        Matrix.scaleM((float[])transform, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
        Matrix.translateM((float[])transform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.rotateM((float[])transform, (int)0, (float)this.mTransformRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.translateM((float[])transform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        if (((TextureConfig)this.mConfig).hasOverlay()) {
            Matrix.translateM((float[])overlayTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])overlayTransform, (int)0, (float)((TextureConfig)this.mConfig).overlayRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.translateM((float[])overlayTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        }
        this.mViewport.drawFrame(((TextureConfig)this.mConfig).textureId, transform);
        if (((TextureConfig)this.mConfig).hasOverlay()) {
            this.mViewport.drawFrame(((TextureConfig)this.mConfig).overlayTextureId, overlayTransform);
        }
        this.mWindow.setPresentationTime(frame.timestamp);
        this.mWindow.swapBuffers();
        this.mFramePool.recycle(frame);
    }

    @Override
    protected void onStopped() {
        super.onStopped();
        this.mFramePool.clear();
        if (this.mWindow != null) {
            this.mWindow.release();
            this.mWindow = null;
        }
        if (this.mViewport != null) {
            this.mViewport.release(true);
            this.mViewport = null;
        }
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    public static class Frame {
        public long timestamp;
        public long timestampMillis;
        public float[] transform = new float[16];
        public float[] overlayTransform = new float[16];

        private Frame() {
        }
    }
}

