/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video.encoding;

import android.annotation.SuppressLint;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.video.encoding.AudioMediaEncoder;
import com.otaliastudios.cameraview.video.encoding.EncoderThread;
import com.otaliastudios.cameraview.video.encoding.MediaEncoder;
import com.otaliastudios.cameraview.video.encoding.OutputBuffer;
import com.otaliastudios.cameraview.video.encoding.OutputBufferPool;
import com.otaliastudios.cameraview.video.encoding.VideoMediaEncoder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(api=18)
public class MediaEncoderEngine {
    private static final String TAG = MediaEncoderEngine.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final boolean DEBUG_PERFORMANCE = true;
    public static final int END_BY_USER = 0;
    public static final int END_BY_MAX_DURATION = 1;
    public static final int END_BY_MAX_SIZE = 2;
    private List<MediaEncoder> mEncoders;
    private MediaMuxer mMediaMuxer;
    private int mStartedEncodersCount;
    private int mReleasedEncodersCount;
    private boolean mMediaMuxerStarted;
    private Controller mController;
    private Listener mListener;
    private int mEndReason = 0;
    private int mPossibleEndReason;
    private final Object mControllerLock = new Object();

    public MediaEncoderEngine(@NonNull File file, @NonNull VideoMediaEncoder videoEncoder, @Nullable AudioMediaEncoder audioEncoder, int maxDuration, long maxSize, @Nullable Listener listener) {
        this.mListener = listener;
        this.mController = new Controller();
        this.mEncoders = new ArrayList<MediaEncoder>();
        this.mEncoders.add(videoEncoder);
        if (audioEncoder != null) {
            this.mEncoders.add(audioEncoder);
        }
        try {
            this.mMediaMuxer = new MediaMuxer(file.toString(), 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mStartedEncodersCount = 0;
        this.mMediaMuxerStarted = false;
        this.mReleasedEncodersCount = 0;
        int bitRate = 0;
        for (MediaEncoder encoder : this.mEncoders) {
            bitRate += encoder.getEncodedBitRate();
        }
        int bytePerSecond = bitRate / 8;
        long sizeMaxDuration = maxSize / (long)bytePerSecond * 1000L;
        long finalMaxDuration = Long.MAX_VALUE;
        if (maxSize > 0L && maxDuration > 0) {
            this.mPossibleEndReason = sizeMaxDuration < (long)maxDuration ? 2 : 1;
            finalMaxDuration = Math.min(sizeMaxDuration, (long)maxDuration);
        } else if (maxSize > 0L) {
            this.mPossibleEndReason = 2;
            finalMaxDuration = sizeMaxDuration;
        } else if (maxDuration > 0) {
            this.mPossibleEndReason = 1;
            finalMaxDuration = maxDuration;
        }
        LOG.w("Computed a max duration of", Float.valueOf((float)finalMaxDuration / 1000.0f));
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.prepare(this.mController, finalMaxDuration);
        }
    }

    public final void start() {
        LOG.i("Passing event to encoders:", "START");
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.start();
        }
    }

    public final void notify(String event, Object data) {
        LOG.i("Passing event to encoders:", event);
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.notify(event, data);
        }
    }

    public final void stop() {
        LOG.i("Passing event to encoders:", "STOP");
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.stop();
        }
    }

    private void end() {
        LOG.i("end:", "Releasing muxer after all encoders have been released.");
        Exception error = null;
        if (this.mMediaMuxer != null) {
            try {
                this.mMediaMuxer.stop();
                this.mMediaMuxer.release();
            }
            catch (Exception e) {
                error = e;
            }
            this.mMediaMuxer = null;
        }
        LOG.w("end:", "Dispatching end to listener - reason:", this.mEndReason, "error:", error);
        if (this.mListener != null) {
            this.mListener.onEncodingEnd(this.mEndReason, error);
            this.mListener = null;
        }
        this.mEndReason = 0;
        this.mStartedEncodersCount = 0;
        this.mReleasedEncodersCount = 0;
        this.mMediaMuxerStarted = false;
        LOG.i("end:", "Completed.");
    }

    @NonNull
    public VideoMediaEncoder getVideoEncoder() {
        return (VideoMediaEncoder)this.mEncoders.get(0);
    }

    @Nullable
    public AudioMediaEncoder getAudioEncoder() {
        if (this.mEncoders.size() > 1) {
            return (AudioMediaEncoder)this.mEncoders.get(1);
        }
        return null;
    }

    public class Controller {
        @SuppressLint(value={"UseSparseArrays"})
        private Map<Integer, Integer> mDebugCount = new HashMap<Integer, Integer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int notifyStarted(@NonNull MediaFormat format) {
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                if (MediaEncoderEngine.this.mMediaMuxerStarted) {
                    throw new IllegalStateException("Trying to start but muxer started already");
                }
                int track = MediaEncoderEngine.this.mMediaMuxer.addTrack(format);
                LOG.w("notifyStarted:", "Assigned track", track, "to format", format.getString("mime"));
                if (++MediaEncoderEngine.this.mStartedEncodersCount == MediaEncoderEngine.this.mEncoders.size()) {
                    LOG.w("notifyStarted:", "All encoders have started. Starting muxer and dispatching onEncodingStart().");
                    MediaEncoderEngine.this.mMediaMuxer.start();
                    MediaEncoderEngine.this.mMediaMuxerStarted = true;
                    if (MediaEncoderEngine.this.mListener != null) {
                        MediaEncoderEngine.this.mListener.onEncodingStart();
                    }
                }
                return track;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isStarted() {
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                return MediaEncoderEngine.this.mMediaMuxerStarted;
            }
        }

        public void write(@NonNull OutputBufferPool pool, @NonNull OutputBuffer buffer) {
            int n;
            if (!MediaEncoderEngine.this.mMediaMuxerStarted) {
                throw new IllegalStateException("Trying to write before muxer started");
            }
            Integer count = this.mDebugCount.get(buffer.trackIndex);
            Integer n2 = buffer.trackIndex;
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            this.mDebugCount.put(n2, n);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(buffer.info.presentationTimeUs / 1000L);
            LOG.v("write:", "Writing into muxer -", "track:", buffer.trackIndex, "presentation:", buffer.info.presentationTimeUs, "readable:", calendar.get(13) + ":" + calendar.get(14), "count:", count);
            MediaEncoderEngine.this.mMediaMuxer.writeSampleData(buffer.trackIndex, buffer.data, buffer.info);
            pool.recycle(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStop(int track) {
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                LOG.w("requestStop:", "Called for track", track);
                if (--MediaEncoderEngine.this.mStartedEncodersCount == 0) {
                    LOG.w("requestStop:", "All encoders have requested a stop. Stopping them.");
                    MediaEncoderEngine.this.mEndReason = MediaEncoderEngine.this.mPossibleEndReason;
                    MediaEncoderEngine.this.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyStopped(int track) {
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                LOG.w("notifyStopped:", "Called for track", track);
                if (++MediaEncoderEngine.this.mReleasedEncodersCount == MediaEncoderEngine.this.mEncoders.size()) {
                    LOG.w("requestStop:", "All encoders have been released. Stopping the muxer.");
                    if (MediaEncoderEngine.this.mListener != null) {
                        MediaEncoderEngine.this.mListener.onEncodingStop();
                    }
                    MediaEncoderEngine.this.end();
                }
            }
        }
    }

    public static interface Listener {
        @EncoderThread
        public void onEncodingStart();

        @EncoderThread
        public void onEncodingStop();

        @EncoderThread
        public void onEncodingEnd(int var1, @Nullable Exception var2);
    }
}

