/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video.encoding;

import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.video.encoding.AudioConfig;
import com.otaliastudios.cameraview.video.encoding.AudioTimestamp;
import com.otaliastudios.cameraview.video.encoding.ByteBufferPool;
import com.otaliastudios.cameraview.video.encoding.EncoderThread;
import com.otaliastudios.cameraview.video.encoding.InputBuffer;
import com.otaliastudios.cameraview.video.encoding.InputBufferPool;
import com.otaliastudios.cameraview.video.encoding.MediaEncoder;
import com.otaliastudios.cameraview.video.encoding.MediaEncoderEngine;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

@RequiresApi(api=18)
public class AudioMediaEncoder
extends MediaEncoder {
    private static final String TAG = AudioMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final boolean PERFORMANCE_DEBUG = true;
    private static final boolean PERFORMANCE_FILL_GAPS = true;
    private boolean mRequestStop = false;
    private AudioEncodingThread mEncoder;
    private AudioRecordingThread mRecorder;
    private ByteBufferPool mByteBufferPool;
    private ByteBuffer mZeroBuffer;
    private final AudioTimestamp mTimestamp;
    private AudioConfig mConfig;
    private InputBufferPool mInputBufferPool = new InputBufferPool();
    private final LinkedBlockingQueue<InputBuffer> mInputBufferQueue = new LinkedBlockingQueue();
    private int mSendCount = 0;
    private int mExecuteCount = 0;
    private long mAvgSendDelay = 0L;
    private long mAvgExecuteDelay = 0L;
    private Map<Long, Long> mSendStartMap = new HashMap<Long, Long>();

    public AudioMediaEncoder(@NonNull AudioConfig config) {
        super("AudioEncoder");
        this.mConfig = config.copy();
        this.mTimestamp = new AudioTimestamp(this.mConfig.byteRate());
        this.mEncoder = new AudioEncodingThread();
        this.mRecorder = new AudioRecordingThread();
    }

    @Override
    @EncoderThread
    protected void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.mConfig.mimeType, (int)this.mConfig.samplingFrequency, (int)this.mConfig.channels);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", this.mConfig.audioFormatChannels());
        audioFormat.setInteger("bitrate", this.mConfig.bitRate);
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)this.mConfig.mimeType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        this.mByteBufferPool = new ByteBufferPool(this.mConfig.frameSize(), this.mConfig.bufferPoolMaxSize());
        this.mZeroBuffer = ByteBuffer.allocateDirect(this.mConfig.frameSize());
    }

    @Override
    @EncoderThread
    protected void onStart() {
        this.mRequestStop = false;
        this.mRecorder.start();
        this.mEncoder.start();
    }

    @Override
    @EncoderThread
    protected void onStop() {
        this.mRequestStop = true;
    }

    @Override
    protected void onStopped() {
        super.onStopped();
        this.mRequestStop = false;
        this.mEncoder = null;
        this.mRecorder = null;
        if (this.mByteBufferPool != null) {
            this.mByteBufferPool.clear();
            this.mByteBufferPool = null;
        }
    }

    @Override
    protected int getEncodedBitRate() {
        return this.mConfig.bitRate;
    }

    private void skipFrames(int frames) {
        try {
            Thread.sleep(AudioTimestamp.bytesToMillis(this.mConfig.frameSize() * frames, this.mConfig.byteRate()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ long access$1202(AudioMediaEncoder x0, long x1) {
        x0.mAvgSendDelay = x1;
        return x0.mAvgSendDelay;
    }

    static /* synthetic */ long access$1200(AudioMediaEncoder x0) {
        return x0.mAvgSendDelay;
    }

    static /* synthetic */ int access$1300(AudioMediaEncoder x0) {
        return x0.mSendCount;
    }

    static /* synthetic */ int access$1304(AudioMediaEncoder x0) {
        return ++x0.mSendCount;
    }

    private class AudioEncodingThread
    extends Thread {
        private AudioEncodingThread() {
            this.setPriority(10);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block0: while (true) {
                if (AudioMediaEncoder.access$1100(AudioMediaEncoder.this).isEmpty()) {
                    AudioMediaEncoder.access$600(AudioMediaEncoder.this, 2);
                    continue;
                }
                AudioMediaEncoder.access$400().i(new Object[]{"encoding thread - performing", AudioMediaEncoder.access$1100(AudioMediaEncoder.this).size(), "pending operations."});
                while (true) {
                    if ((inputBuffer = (InputBuffer)AudioMediaEncoder.access$1100(AudioMediaEncoder.this).peek()) == null) ** break;
                    sendEnd = System.nanoTime() / 1000000L;
                    sendStart = (Long)AudioMediaEncoder.access$900(AudioMediaEncoder.this).remove(inputBuffer.timestamp);
                    if (sendStart != null) {
                        AudioMediaEncoder.access$1202(AudioMediaEncoder.this, (AudioMediaEncoder.access$1200(AudioMediaEncoder.this) * (long)AudioMediaEncoder.access$1300(AudioMediaEncoder.this) + (sendEnd - sendStart)) / (long)AudioMediaEncoder.access$1304(AudioMediaEncoder.this));
                        AudioMediaEncoder.access$400().v(new Object[]{"send delay millis:", sendEnd - sendStart, "average:", AudioMediaEncoder.access$1200(AudioMediaEncoder.this)});
                    }
                    if (inputBuffer.isEndOfStream) break block0;
                    if (AudioMediaEncoder.this.tryAcquireInputBuffer(inputBuffer)) {
                        this.encode(inputBuffer);
                        continue;
                    }
                    AudioMediaEncoder.access$600(AudioMediaEncoder.this, 1);
                }
                break;
            }
            AudioMediaEncoder.this.acquireInputBuffer(inputBuffer);
            this.encode(inputBuffer);
            AudioMediaEncoder.access$1000(AudioMediaEncoder.this).clear();
            AudioMediaEncoder.access$400().e(new Object[]{"EXECUTE DELAY MILLIS:", AudioMediaEncoder.access$1400(AudioMediaEncoder.this), "COUNT:", AudioMediaEncoder.access$1500(AudioMediaEncoder.this)});
            AudioMediaEncoder.access$400().e(new Object[]{"SEND DELAY MILLIS:", AudioMediaEncoder.access$1200(AudioMediaEncoder.this), "COUNT:", AudioMediaEncoder.access$1300(AudioMediaEncoder.this)});
        }

        private void encode(@NonNull InputBuffer buffer) {
            long executeStart = System.nanoTime() / 1000000L;
            LOG.i("encoding thread - performing pending operation for timestamp:", buffer.timestamp, "- encoding.");
            buffer.data.put(buffer.source);
            AudioMediaEncoder.this.mByteBufferPool.recycle(buffer.source);
            AudioMediaEncoder.this.mInputBufferQueue.remove(buffer);
            AudioMediaEncoder.this.encodeInputBuffer(buffer);
            boolean eos = buffer.isEndOfStream;
            AudioMediaEncoder.this.mInputBufferPool.recycle(buffer);
            LOG.i("encoding thread - performing pending operation for timestamp:", buffer.timestamp, "- draining.");
            AudioMediaEncoder.this.drainOutput(buffer.isEndOfStream);
            long executeEnd = System.nanoTime() / 1000000L;
            AudioMediaEncoder.this.mAvgExecuteDelay = (AudioMediaEncoder.this.mAvgExecuteDelay * (long)AudioMediaEncoder.this.mExecuteCount + (executeEnd - executeStart)) / (long)(++AudioMediaEncoder.this.mExecuteCount);
            LOG.v("execute delay millis:", executeEnd - executeStart, "average:", AudioMediaEncoder.this.mAvgExecuteDelay);
        }
    }

    private class AudioRecordingThread
    extends Thread {
        private AudioRecord mAudioRecord;
        private ByteBuffer mCurrentBuffer;
        private int mReadBytes;
        private long mLastTimeUs;
        private long mFirstTimeUs = Long.MIN_VALUE;

        private AudioRecordingThread() {
            int bufferSize;
            int n = ((AudioMediaEncoder)AudioMediaEncoder.this).mConfig.samplingFrequency;
            int n2 = AudioMediaEncoder.this.mConfig.audioFormatChannels();
            AudioMediaEncoder.this.mConfig.getClass();
            int minBufferSize = AudioRecord.getMinBufferSize((int)n, (int)n2, (int)2);
            for (bufferSize = AudioMediaEncoder.this.mConfig.frameSize() * AudioMediaEncoder.this.mConfig.audioRecordBufferFrames(); bufferSize < minBufferSize; bufferSize += AudioMediaEncoder.this.mConfig.frameSize()) {
            }
            int n3 = ((AudioMediaEncoder)AudioMediaEncoder.this).mConfig.samplingFrequency;
            int n4 = AudioMediaEncoder.this.mConfig.audioFormatChannels();
            AudioMediaEncoder.this.mConfig.getClass();
            this.mAudioRecord = new AudioRecord(5, n3, n4, 2, bufferSize);
            this.setPriority(10);
        }

        @Override
        public void run() {
            this.mAudioRecord.startRecording();
            while (!AudioMediaEncoder.this.mRequestStop) {
                this.read(false);
            }
            LOG.w("Stop was requested. We're out of the loop. Will post an endOfStream.");
            this.read(true);
            this.mAudioRecord.stop();
            this.mAudioRecord.release();
            this.mAudioRecord = null;
        }

        private void read(boolean endOfStream) {
            this.mCurrentBuffer = (ByteBuffer)AudioMediaEncoder.this.mByteBufferPool.get();
            if (this.mCurrentBuffer == null) {
                if (endOfStream) {
                    LOG.v("read thread - eos: true - No buffer, retrying.");
                    this.read(true);
                } else {
                    LOG.w("read thread - eos: false - Skipping audio frame, encoding is too slow.");
                    AudioMediaEncoder.this.skipFrames(6);
                }
            } else {
                this.mCurrentBuffer.clear();
                long before = System.nanoTime();
                this.mReadBytes = this.mAudioRecord.read(this.mCurrentBuffer, AudioMediaEncoder.this.mConfig.frameSize());
                long after = System.nanoTime();
                float delayMillis = (float)(after - before) / 1000000.0f;
                float durationMillis = AudioTimestamp.bytesToMillis(this.mReadBytes, AudioMediaEncoder.this.mConfig.byteRate());
                LOG.v("read thread - reading took:", Float.valueOf(delayMillis), "should be:", Float.valueOf(durationMillis), "delay:", Float.valueOf(delayMillis - durationMillis));
                LOG.i("read thread - eos:", endOfStream, "- Read new audio frame. Bytes:", this.mReadBytes);
                if (this.mReadBytes > 0) {
                    this.increaseTime(this.mReadBytes, endOfStream);
                    LOG.i("read thread - eos:", endOfStream, "- mLastTimeUs:", this.mLastTimeUs);
                    this.mCurrentBuffer.limit(this.mReadBytes);
                    this.enqueue(this.mCurrentBuffer, this.mLastTimeUs, endOfStream);
                } else if (this.mReadBytes == -3) {
                    LOG.e("read thread - eos:", endOfStream, "- Got AudioRecord.ERROR_INVALID_OPERATION");
                } else if (this.mReadBytes == -2) {
                    LOG.e("read thread - eos:", endOfStream, "- Got AudioRecord.ERROR_BAD_VALUE");
                }
            }
        }

        private void increaseTime(int readBytes, boolean endOfStream) {
            int gaps;
            boolean didReachMaxLength;
            this.mLastTimeUs = AudioMediaEncoder.this.mTimestamp.increaseUs(readBytes);
            if (this.mFirstTimeUs == Long.MIN_VALUE) {
                this.mFirstTimeUs = this.mLastTimeUs;
                AudioMediaEncoder.this.notifyFirstFrameMillis(System.currentTimeMillis() - AudioTimestamp.bytesToMillis(readBytes, AudioMediaEncoder.this.mConfig.byteRate()));
            }
            boolean bl = didReachMaxLength = this.mLastTimeUs - this.mFirstTimeUs > AudioMediaEncoder.this.getMaxLengthMillis() * 1000L;
            if (didReachMaxLength && !endOfStream) {
                LOG.w("read thread - this frame reached the maxLength! deltaUs:", this.mLastTimeUs - this.mFirstTimeUs);
                AudioMediaEncoder.this.notifyMaxLengthReached();
            }
            if ((gaps = AudioMediaEncoder.this.mTimestamp.getGapCount(AudioMediaEncoder.this.mConfig.frameSize())) > 0) {
                long gapStart = AudioMediaEncoder.this.mTimestamp.getGapStartUs(this.mLastTimeUs);
                long frameUs = AudioTimestamp.bytesToUs(AudioMediaEncoder.this.mConfig.frameSize(), AudioMediaEncoder.this.mConfig.byteRate());
                LOG.w("read thread - GAPS: trying to add", gaps, "zeroed buffers");
                for (int i = 0; i < gaps; ++i) {
                    ByteBuffer zeroBuffer = (ByteBuffer)AudioMediaEncoder.this.mByteBufferPool.get();
                    if (zeroBuffer == null) {
                        LOG.e("read thread - GAPS: aborting because we have no free buffer.");
                        break;
                    }
                    zeroBuffer.position(0);
                    zeroBuffer.put(AudioMediaEncoder.this.mZeroBuffer);
                    zeroBuffer.clear();
                    this.enqueue(zeroBuffer, gapStart, false);
                    gapStart += frameUs;
                }
            }
        }

        private void enqueue(@NonNull ByteBuffer byteBuffer, long timestamp, boolean isEndOfStream) {
            AudioMediaEncoder.this.mSendStartMap.put(timestamp, System.nanoTime() / 1000000L);
            int readBytes = byteBuffer.remaining();
            InputBuffer inputBuffer = (InputBuffer)AudioMediaEncoder.this.mInputBufferPool.get();
            inputBuffer.source = byteBuffer;
            inputBuffer.timestamp = timestamp;
            inputBuffer.length = readBytes;
            inputBuffer.isEndOfStream = isEndOfStream;
            AudioMediaEncoder.this.mInputBufferQueue.add(inputBuffer);
        }
    }
}

