/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video.encoding;

import androidx.annotation.NonNull;

public class AudioConfig {
    public int bitRate;
    public int channels = 1;
    final String mimeType = "audio/mp4a-latm";
    final int encoding = 2;
    final int samplingFrequency = 44100;
    final int sampleSizePerChannel = 2;
    final int byteRatePerChannel = 88200;

    @NonNull
    AudioConfig copy() {
        AudioConfig config = new AudioConfig();
        config.bitRate = this.bitRate;
        config.channels = this.channels;
        return config;
    }

    int byteRate() {
        return 88200 * this.channels;
    }

    int bitRate() {
        return this.byteRate() * 8;
    }

    int audioFormatChannels() {
        if (this.channels == 1) {
            return 16;
        }
        if (this.channels == 2) {
            return 12;
        }
        throw new RuntimeException("Invalid number of channels: " + this.channels);
    }

    int frameSize() {
        return 1024 * this.channels;
    }

    int audioRecordBufferFrames() {
        return 25;
    }

    int bufferPoolMaxSize() {
        return 80;
    }
}

