/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.VideoResult;

public abstract class VideoRecorder {
    @VisibleForTesting(otherwise=4)
    VideoResult.Stub mResult;
    private final VideoResultListener mListener;
    protected Exception mError;
    private boolean mIsRecording;

    VideoRecorder(@Nullable VideoResultListener listener) {
        this.mListener = listener;
    }

    public final void start(@NonNull VideoResult.Stub stub) {
        this.mResult = stub;
        this.mIsRecording = true;
        this.onStart();
    }

    public final void stop() {
        this.onStop();
    }

    public boolean isRecording() {
        return this.mIsRecording;
    }

    protected abstract void onStart();

    protected abstract void onStop();

    @CallSuper
    protected void dispatchResult() {
        this.mIsRecording = false;
        if (this.mListener != null) {
            this.mListener.onVideoResult(this.mResult, this.mError);
        }
        this.mResult = null;
        this.mError = null;
    }

    @CallSuper
    protected void dispatchVideoRecordingStart() {
        if (this.mListener != null) {
            this.mListener.onVideoRecordingStart();
        }
    }

    @CallSuper
    protected void dispatchVideoRecordingEnd() {
        if (this.mListener != null) {
            this.mListener.onVideoRecordingEnd();
        }
    }

    public static interface VideoResultListener {
        public void onVideoResult(@Nullable VideoResult.Stub var1, @Nullable Exception var2);

        public void onVideoRecordingStart();

        public void onVideoRecordingEnd();
    }
}

