/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.internal.egl.EglViewport;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.preview.GlCameraPreview;
import com.otaliastudios.cameraview.preview.RendererFrameCallback;
import com.otaliastudios.cameraview.preview.RendererThread;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.VideoRecorder;
import com.otaliastudios.cameraview.video.encoding.AudioConfig;
import com.otaliastudios.cameraview.video.encoding.AudioMediaEncoder;
import com.otaliastudios.cameraview.video.encoding.EncoderThread;
import com.otaliastudios.cameraview.video.encoding.MediaEncoderEngine;
import com.otaliastudios.cameraview.video.encoding.TextureConfig;
import com.otaliastudios.cameraview.video.encoding.TextureMediaEncoder;

@RequiresApi(api=18)
public class SnapshotVideoRecorder
extends VideoRecorder
implements RendererFrameCallback,
MediaEncoderEngine.Listener {
    private static final String TAG = SnapshotVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int DEFAULT_VIDEO_FRAMERATE = 30;
    private static final int DEFAULT_AUDIO_BITRATE = 64000;
    private static final int STATE_RECORDING = 0;
    private static final int STATE_NOT_RECORDING = 1;
    private MediaEncoderEngine mEncoderEngine;
    private GlCameraPreview mPreview;
    private int mCurrentState = 1;
    private int mDesiredState = 1;
    private int mTextureId = 0;
    private int mOverlayTextureId = 0;
    private SurfaceTexture mOverlaySurfaceTexture;
    private Surface mOverlaySurface;
    private Overlay mOverlay;
    private boolean mHasOverlay;
    private int mOverlayRotation;

    private static int estimateVideoBitRate(@NonNull Size size, int frameRate) {
        return (int)(0.07f * (float)size.getWidth() * (float)size.getHeight() * (float)frameRate);
    }

    public SnapshotVideoRecorder(@NonNull CameraEngine engine, @NonNull GlCameraPreview preview, @Nullable Overlay overlay, int overlayRotation) {
        super(engine);
        this.mPreview = preview;
        this.mOverlay = overlay;
        this.mHasOverlay = overlay != null && overlay.drawsOn(Overlay.Target.VIDEO_SNAPSHOT);
        this.mOverlayRotation = overlayRotation;
    }

    @Override
    protected void onStart() {
        this.mPreview.addRendererFrameCallback(this);
        this.mDesiredState = 0;
    }

    @Override
    protected void onStop() {
        this.mDesiredState = 1;
    }

    @Override
    @RendererThread
    public void onRendererTextureCreated(int textureId) {
        this.mTextureId = textureId;
        if (this.mHasOverlay) {
            EglViewport temp = new EglViewport();
            this.mOverlayTextureId = temp.createTexture();
            this.mOverlaySurfaceTexture = new SurfaceTexture(this.mOverlayTextureId);
            this.mOverlaySurfaceTexture.setDefaultBufferSize(this.mResult.size.getWidth(), this.mResult.size.getHeight());
            this.mOverlaySurface = new Surface(this.mOverlaySurfaceTexture);
        }
    }

    @Override
    @RendererThread
    public void onRendererFrame(@NonNull SurfaceTexture surfaceTexture, float scaleX, float scaleY) {
        if (this.mCurrentState == 1 && this.mDesiredState == 0) {
            LOG.i("Starting the encoder engine.");
            if (this.mResult.videoFrameRate <= 0) {
                this.mResult.videoFrameRate = 30;
            }
            if (this.mResult.videoBitRate <= 0) {
                this.mResult.videoBitRate = SnapshotVideoRecorder.estimateVideoBitRate(this.mResult.size, this.mResult.videoFrameRate);
            }
            if (this.mResult.audioBitRate <= 0) {
                this.mResult.audioBitRate = 64000;
            }
            Size size = this.mResult.size;
            int width = size.getWidth();
            int height = size.getHeight();
            width = width % 2 == 0 ? width : width + 1;
            height = height % 2 == 0 ? height : height + 1;
            String type = "";
            switch (this.mResult.videoCodec) {
                case H_263: {
                    type = "video/3gpp";
                    break;
                }
                case H_264: {
                    type = "video/avc";
                    break;
                }
                case DEVICE_DEFAULT: {
                    type = "video/avc";
                }
            }
            LOG.w("Creating frame encoder. Rotation:", this.mResult.rotation);
            TextureConfig videoConfig = new TextureConfig();
            videoConfig.width = width;
            videoConfig.height = height;
            videoConfig.bitRate = this.mResult.videoBitRate;
            videoConfig.frameRate = this.mResult.videoFrameRate;
            videoConfig.rotation = this.mResult.rotation;
            videoConfig.mimeType = type;
            videoConfig.textureId = this.mTextureId;
            videoConfig.scaleX = scaleX;
            videoConfig.scaleY = scaleY;
            videoConfig.eglContext = EGL14.eglGetCurrentContext();
            if (this.mHasOverlay) {
                videoConfig.overlayTextureId = this.mOverlayTextureId;
                videoConfig.overlayRotation = this.mOverlayRotation;
            }
            TextureMediaEncoder videoEncoder = new TextureMediaEncoder(videoConfig);
            AudioMediaEncoder audioEncoder = null;
            if (this.mResult.audio == Audio.ON || this.mResult.audio == Audio.MONO || this.mResult.audio == Audio.STEREO) {
                AudioConfig audioConfig = new AudioConfig();
                audioConfig.bitRate = this.mResult.audioBitRate;
                if (this.mResult.audio == Audio.MONO) {
                    audioConfig.channels = 1;
                }
                if (this.mResult.audio == Audio.STEREO) {
                    audioConfig.channels = 2;
                }
                audioEncoder = new AudioMediaEncoder(audioConfig);
            }
            this.mEncoderEngine = new MediaEncoderEngine(this.mResult.file, videoEncoder, audioEncoder, this.mResult.maxDuration, this.mResult.maxSize, this);
            this.mEncoderEngine.start();
            this.mResult.rotation = 0;
            this.mCurrentState = 0;
        }
        if (this.mCurrentState == 0) {
            LOG.v("dispatching frame.");
            TextureMediaEncoder textureEncoder = (TextureMediaEncoder)this.mEncoderEngine.getVideoEncoder();
            TextureMediaEncoder.Frame frame = textureEncoder.acquireFrame();
            frame.timestamp = surfaceTexture.getTimestamp();
            frame.timestampMillis = System.currentTimeMillis();
            surfaceTexture.getTransformMatrix(frame.transform);
            if (this.mHasOverlay) {
                try {
                    Canvas surfaceCanvas = this.mOverlaySurface.lockCanvas(null);
                    surfaceCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    this.mOverlay.drawOn(Overlay.Target.VIDEO_SNAPSHOT, surfaceCanvas);
                    this.mOverlaySurface.unlockCanvasAndPost(surfaceCanvas);
                }
                catch (Surface.OutOfResourcesException e) {
                    LOG.w(new Object[]{"Got Surface.OutOfResourcesException while drawing video overlays", e});
                }
                this.mOverlaySurfaceTexture.updateTexImage();
                this.mOverlaySurfaceTexture.getTransformMatrix(frame.overlayTransform);
            }
            if (this.mEncoderEngine != null) {
                this.mEncoderEngine.notify("frame", frame);
            }
        }
        if (this.mCurrentState == 0 && this.mDesiredState == 1) {
            LOG.i("Stopping the encoder engine.");
            this.mCurrentState = 1;
            this.mEncoderEngine.stop();
            this.mEncoderEngine = null;
            this.mPreview.removeRendererFrameCallback(this);
            this.mPreview = null;
            if (this.mOverlaySurfaceTexture != null) {
                this.mOverlaySurfaceTexture.release();
                this.mOverlaySurfaceTexture = null;
            }
            if (this.mOverlaySurface != null) {
                this.mOverlaySurface.release();
                this.mOverlaySurface = null;
            }
        }
    }

    @Override
    public void onEncodingStart() {
        this.dispatchVideoRecordingStart();
    }

    @Override
    public void onEncodingStop() {
        this.dispatchVideoRecordingEnd();
    }

    @Override
    @EncoderThread
    public void onEncodingEnd(int stopReason, @Nullable Exception e) {
        if (e != null) {
            LOG.e("Error onEncodingEnd", e);
            this.mResult = null;
            this.mError = e;
        } else if (stopReason == 1) {
            LOG.i("onEncodingEnd because of max duration.");
            this.mResult.endReason = 2;
        } else if (stopReason == 2) {
            LOG.i("onEncodingEnd because of max size.");
            this.mResult.endReason = 1;
        } else {
            LOG.i("onEncodingEnd because of user.");
        }
        this.mCurrentState = 1;
        this.mDesiredState = 1;
        this.mPreview.removeRendererFrameCallback(this);
        this.mEncoderEngine = null;
        this.dispatchResult();
    }
}

