/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.VideoRecorder;

public abstract class FullVideoRecorder
extends VideoRecorder {
    private static final String TAG = FullVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    protected MediaRecorder mMediaRecorder;
    protected CamcorderProfile mProfile;
    private boolean mMediaRecorderPrepared;

    FullVideoRecorder(@Nullable VideoRecorder.VideoResultListener listener) {
        super(listener);
    }

    protected boolean prepareMediaRecorder(@NonNull VideoResult.Stub stub) {
        if (this.mMediaRecorderPrepared) {
            return true;
        }
        return this.onPrepareMediaRecorder(stub, new MediaRecorder());
    }

    protected boolean onPrepareMediaRecorder(@NonNull VideoResult.Stub stub, @NonNull MediaRecorder mediaRecorder) {
        Size size;
        this.mMediaRecorder = mediaRecorder;
        Size size2 = size = stub.rotation % 180 != 0 ? stub.size.flip() : stub.size;
        if (stub.audio == Audio.ON || stub.audio == Audio.MONO || stub.audio == Audio.STEREO) {
            this.mMediaRecorder.setAudioSource(0);
        }
        this.mMediaRecorder.setOutputFormat(this.mProfile.fileFormat);
        if (stub.videoFrameRate <= 0) {
            this.mMediaRecorder.setVideoFrameRate(this.mProfile.videoFrameRate);
            stub.videoFrameRate = this.mProfile.videoFrameRate;
        } else {
            this.mMediaRecorder.setVideoFrameRate(stub.videoFrameRate);
        }
        this.mMediaRecorder.setVideoSize(size.getWidth(), size.getHeight());
        switch (stub.videoCodec) {
            case H_263: {
                this.mMediaRecorder.setVideoEncoder(1);
                break;
            }
            case H_264: {
                this.mMediaRecorder.setVideoEncoder(2);
                break;
            }
            case DEVICE_DEFAULT: {
                this.mMediaRecorder.setVideoEncoder(this.mProfile.videoCodec);
            }
        }
        if (stub.videoBitRate <= 0) {
            this.mMediaRecorder.setVideoEncodingBitRate(this.mProfile.videoBitRate);
            stub.videoBitRate = this.mProfile.videoBitRate;
        } else {
            this.mMediaRecorder.setVideoEncodingBitRate(stub.videoBitRate);
        }
        if (stub.audio == Audio.ON || stub.audio == Audio.MONO || stub.audio == Audio.STEREO) {
            if (stub.audio == Audio.ON) {
                this.mMediaRecorder.setAudioChannels(this.mProfile.audioChannels);
            } else if (stub.audio == Audio.MONO) {
                this.mMediaRecorder.setAudioChannels(1);
            } else if (stub.audio == Audio.STEREO) {
                this.mMediaRecorder.setAudioChannels(2);
            }
            this.mMediaRecorder.setAudioSamplingRate(this.mProfile.audioSampleRate);
            this.mMediaRecorder.setAudioEncoder(this.mProfile.audioCodec);
            if (stub.audioBitRate <= 0) {
                this.mMediaRecorder.setAudioEncodingBitRate(this.mProfile.audioBitRate);
                stub.audioBitRate = this.mProfile.audioBitRate;
            } else {
                this.mMediaRecorder.setAudioEncodingBitRate(stub.audioBitRate);
            }
        }
        if (stub.location != null) {
            this.mMediaRecorder.setLocation((float)stub.location.getLatitude(), (float)stub.location.getLongitude());
        }
        this.mMediaRecorder.setOutputFile(stub.file.getAbsolutePath());
        this.mMediaRecorder.setOrientationHint(stub.rotation);
        this.mMediaRecorder.setMaxFileSize(stub.maxSize);
        this.mMediaRecorder.setMaxDuration(stub.maxDuration);
        this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

            public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
                switch (what) {
                    case 800: {
                        FullVideoRecorder.this.mResult.endReason = 2;
                        FullVideoRecorder.this.stop();
                        break;
                    }
                    case 801: {
                        FullVideoRecorder.this.mResult.endReason = 1;
                        FullVideoRecorder.this.stop();
                    }
                }
            }
        });
        try {
            this.mMediaRecorder.prepare();
            this.mMediaRecorderPrepared = true;
            this.mError = null;
            return true;
        }
        catch (Exception e) {
            LOG.w("prepareMediaRecorder:", "Error while preparing media recorder.", e);
            this.mMediaRecorderPrepared = false;
            this.mError = e;
            return false;
        }
    }

    @Override
    protected void onStart() {
        if (!this.prepareMediaRecorder(this.mResult)) {
            this.mResult = null;
            this.stop();
            return;
        }
        try {
            this.mMediaRecorder.start();
            this.dispatchVideoRecordingStart();
        }
        catch (Exception e) {
            LOG.w("start:", "Error while starting media recorder.", e);
            this.mResult = null;
            this.mError = e;
            this.stop();
        }
    }

    @Override
    protected void onStop() {
        if (this.mMediaRecorder != null) {
            block3: {
                this.dispatchVideoRecordingEnd();
                try {
                    this.mMediaRecorder.stop();
                }
                catch (Exception e) {
                    LOG.w("stop:", "Error while closing media recorder.", e);
                    this.mResult = null;
                    if (this.mError != null) break block3;
                    this.mError = e;
                }
            }
            this.mMediaRecorder.release();
        }
        this.mProfile = null;
        this.mMediaRecorder = null;
        this.mMediaRecorderPrepared = false;
        this.dispatchResult();
    }
}

