/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.preview;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.R;
import com.otaliastudios.cameraview.internal.egl.EglViewport;
import com.otaliastudios.cameraview.internal.utils.Op;
import com.otaliastudios.cameraview.preview.CameraPreview;
import com.otaliastudios.cameraview.preview.RendererFrameCallback;
import com.otaliastudios.cameraview.preview.RendererThread;
import com.otaliastudios.cameraview.size.AspectRatio;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GlCameraPreview
extends CameraPreview<GLSurfaceView, SurfaceTexture> {
    private boolean mDispatched;
    private final float[] mTransformMatrix = new float[16];
    private int mOutputTextureId = 0;
    private SurfaceTexture mInputSurfaceTexture;
    private EglViewport mOutputViewport;
    private final Set<RendererFrameCallback> mRendererFrameCallbacks = Collections.synchronizedSet(new HashSet());
    @VisibleForTesting
    float mCropScaleX = 1.0f;
    @VisibleForTesting
    float mCropScaleY = 1.0f;
    private View mRootView;

    public GlCameraPreview(@NonNull Context context, @NonNull ViewGroup parent) {
        super(context, parent);
    }

    @Override
    @NonNull
    protected GLSurfaceView onCreateView(@NonNull Context context, @NonNull ViewGroup parent) {
        ViewGroup root = (ViewGroup)LayoutInflater.from((Context)context).inflate(R.layout.cameraview_gl_view, parent, false);
        GLSurfaceView glView = (GLSurfaceView)root.findViewById(R.id.gl_surface_view);
        glView.setEGLContextClientVersion(2);
        glView.setRenderer((GLSurfaceView.Renderer)this.instantiateRenderer());
        glView.setRenderMode(0);
        glView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                GlCameraPreview.this.dispatchOnSurfaceDestroyed();
                GlCameraPreview.this.mDispatched = false;
            }
        });
        parent.addView((View)root, 0);
        this.mRootView = root;
        return glView;
    }

    @Override
    @NonNull
    View getRootView() {
        return this.mRootView;
    }

    @Override
    public void onResume() {
        super.onResume();
        ((GLSurfaceView)this.getView()).onResume();
    }

    @Override
    public void onPause() {
        super.onPause();
        ((GLSurfaceView)this.getView()).onPause();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRendererFrameCallbacks.clear();
        if (this.mInputSurfaceTexture != null) {
            this.mInputSurfaceTexture.setOnFrameAvailableListener(null);
            this.mInputSurfaceTexture.release();
            this.mInputSurfaceTexture = null;
        }
        this.mOutputTextureId = 0;
        if (this.mOutputViewport != null) {
            this.mOutputViewport.release();
            this.mOutputViewport = null;
        }
    }

    @Override
    @NonNull
    public Class<SurfaceTexture> getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    @NonNull
    public SurfaceTexture getOutput() {
        return this.mInputSurfaceTexture;
    }

    @Override
    public boolean supportsCropping() {
        return true;
    }

    @Override
    protected void crop(@NonNull Op<Void> op) {
        op.start();
        if (this.mInputStreamWidth > 0 && this.mInputStreamHeight > 0 && this.mOutputSurfaceWidth > 0 && this.mOutputSurfaceHeight > 0) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            AspectRatio current = AspectRatio.of(this.mOutputSurfaceWidth, this.mOutputSurfaceHeight);
            AspectRatio target = AspectRatio.of(this.mInputStreamWidth, this.mInputStreamHeight);
            if (current.toFloat() >= target.toFloat()) {
                scaleY = current.toFloat() / target.toFloat();
            } else {
                scaleX = target.toFloat() / current.toFloat();
            }
            this.mCropping = scaleX > 1.02f || scaleY > 1.02f;
            this.mCropScaleX = 1.0f / scaleX;
            this.mCropScaleY = 1.0f / scaleY;
            ((GLSurfaceView)this.getView()).requestRender();
        }
        op.end(null);
    }

    public void addRendererFrameCallback(final @NonNull RendererFrameCallback callback) {
        ((GLSurfaceView)this.getView()).queueEvent(new Runnable(){

            @Override
            public void run() {
                GlCameraPreview.this.mRendererFrameCallbacks.add(callback);
                if (GlCameraPreview.this.mOutputTextureId != 0) {
                    callback.onRendererTextureCreated(GlCameraPreview.this.mOutputTextureId);
                }
            }
        });
    }

    public void removeRendererFrameCallback(@NonNull RendererFrameCallback callback) {
        this.mRendererFrameCallbacks.remove(callback);
    }

    protected int getTextureId() {
        return this.mOutputTextureId;
    }

    @NonNull
    protected Renderer instantiateRenderer() {
        return new Renderer();
    }

    public class Renderer
    implements GLSurfaceView.Renderer {
        @RendererThread
        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            GlCameraPreview.this.mOutputViewport = new EglViewport();
            GlCameraPreview.this.mOutputTextureId = GlCameraPreview.this.mOutputViewport.createTexture();
            GlCameraPreview.this.mInputSurfaceTexture = new SurfaceTexture(GlCameraPreview.this.mOutputTextureId);
            ((GLSurfaceView)GlCameraPreview.this.getView()).queueEvent(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set set = GlCameraPreview.this.mRendererFrameCallbacks;
                    synchronized (set) {
                        for (RendererFrameCallback callback : GlCameraPreview.this.mRendererFrameCallbacks) {
                            callback.onRendererTextureCreated(GlCameraPreview.this.mOutputTextureId);
                        }
                    }
                }
            });
            GlCameraPreview.this.mInputSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    ((GLSurfaceView)GlCameraPreview.this.getView()).requestRender();
                }
            });
        }

        @RendererThread
        public void onSurfaceChanged(GL10 gl, int width, int height) {
            gl.glViewport(0, 0, width, height);
            if (!GlCameraPreview.this.mDispatched) {
                GlCameraPreview.this.dispatchOnSurfaceAvailable(width, height);
                GlCameraPreview.this.mDispatched = true;
            } else if (width != GlCameraPreview.this.mOutputSurfaceWidth || height != GlCameraPreview.this.mOutputSurfaceHeight) {
                GlCameraPreview.this.dispatchOnSurfaceSizeChanged(width, height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RendererThread
        public void onDrawFrame(GL10 gl) {
            if (GlCameraPreview.this.mInputSurfaceTexture == null) {
                return;
            }
            GlCameraPreview.this.mInputSurfaceTexture.updateTexImage();
            if (GlCameraPreview.this.mInputStreamWidth <= 0 || GlCameraPreview.this.mInputStreamHeight <= 0) {
                return;
            }
            GlCameraPreview.this.mInputSurfaceTexture.getTransformMatrix(GlCameraPreview.this.mTransformMatrix);
            if (GlCameraPreview.this.mDrawRotation != 0) {
                Matrix.translateM((float[])GlCameraPreview.this.mTransformMatrix, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
                Matrix.rotateM((float[])GlCameraPreview.this.mTransformMatrix, (int)0, (float)GlCameraPreview.this.mDrawRotation, (float)0.0f, (float)0.0f, (float)1.0f);
                Matrix.translateM((float[])GlCameraPreview.this.mTransformMatrix, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
            }
            if (GlCameraPreview.this.isCropping()) {
                float translX = (1.0f - GlCameraPreview.this.mCropScaleX) / 2.0f;
                float translY = (1.0f - GlCameraPreview.this.mCropScaleY) / 2.0f;
                Matrix.translateM((float[])GlCameraPreview.this.mTransformMatrix, (int)0, (float)translX, (float)translY, (float)0.0f);
                Matrix.scaleM((float[])GlCameraPreview.this.mTransformMatrix, (int)0, (float)GlCameraPreview.this.mCropScaleX, (float)GlCameraPreview.this.mCropScaleY, (float)1.0f);
            }
            GlCameraPreview.this.mOutputViewport.drawFrame(GlCameraPreview.this.mOutputTextureId, GlCameraPreview.this.mTransformMatrix);
            Set set = GlCameraPreview.this.mRendererFrameCallbacks;
            synchronized (set) {
                for (RendererFrameCallback callback : GlCameraPreview.this.mRendererFrameCallbacks) {
                    callback.onRendererFrame(GlCameraPreview.this.mInputSurfaceTexture, GlCameraPreview.this.mCropScaleX, GlCameraPreview.this.mCropScaleY);
                }
            }
        }
    }
}

