/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.Matrix;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.engine.offset.Axis;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.internal.egl.EglCore;
import com.otaliastudios.cameraview.internal.egl.EglViewport;
import com.otaliastudios.cameraview.internal.egl.EglWindowSurface;
import com.otaliastudios.cameraview.internal.utils.CropHelper;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import com.otaliastudios.cameraview.preview.GlCameraPreview;
import com.otaliastudios.cameraview.preview.RendererFrameCallback;
import com.otaliastudios.cameraview.preview.RendererThread;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;

public class SnapshotGlPictureRecorder
extends PictureRecorder {
    private static final String TAG = SnapshotGlPictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private CameraEngine mEngine;
    private GlCameraPreview mPreview;
    private AspectRatio mOutputRatio;
    private Overlay mOverlay;
    private boolean mHasOverlay;

    public SnapshotGlPictureRecorder(@NonNull PictureResult.Stub stub, @NonNull CameraEngine engine, @NonNull GlCameraPreview preview, @NonNull AspectRatio outputRatio, @Nullable Overlay overlay) {
        super(stub, engine);
        this.mEngine = engine;
        this.mPreview = preview;
        this.mOutputRatio = outputRatio;
        this.mOverlay = overlay;
        this.mHasOverlay = overlay != null && overlay.drawsOn(Overlay.Target.PICTURE_SNAPSHOT);
    }

    @Override
    @TargetApi(value=19)
    public void take() {
        this.mPreview.addRendererFrameCallback(new RendererFrameCallback(){
            int mTextureId;
            SurfaceTexture mSurfaceTexture;
            float[] mTransform;
            int mOverlayTextureId = 0;
            SurfaceTexture mOverlaySurfaceTexture;
            Surface mOverlaySurface;
            float[] mOverlayTransform;
            EglViewport mViewport;

            @Override
            @RendererThread
            public void onRendererTextureCreated(int textureId) {
                this.mTextureId = textureId;
                this.mViewport = new EglViewport();
                this.mSurfaceTexture = new SurfaceTexture(this.mTextureId, true);
                Rect crop = CropHelper.computeCrop(SnapshotGlPictureRecorder.this.mResult.size, SnapshotGlPictureRecorder.this.mOutputRatio);
                SnapshotGlPictureRecorder.this.mResult.size = new Size(crop.width(), crop.height());
                this.mSurfaceTexture.setDefaultBufferSize(SnapshotGlPictureRecorder.this.mResult.size.getWidth(), SnapshotGlPictureRecorder.this.mResult.size.getHeight());
                this.mTransform = new float[16];
                if (SnapshotGlPictureRecorder.this.mHasOverlay) {
                    this.mOverlayTextureId = this.mViewport.createTexture();
                    this.mOverlaySurfaceTexture = new SurfaceTexture(this.mOverlayTextureId, true);
                    this.mOverlaySurfaceTexture.setDefaultBufferSize(SnapshotGlPictureRecorder.this.mResult.size.getWidth(), SnapshotGlPictureRecorder.this.mResult.size.getHeight());
                    this.mOverlaySurface = new Surface(this.mOverlaySurfaceTexture);
                    this.mOverlayTransform = new float[16];
                }
            }

            @Override
            @RendererThread
            public void onRendererFrame(@NonNull SurfaceTexture surfaceTexture, final float scaleX, final float scaleY) {
                SnapshotGlPictureRecorder.this.mPreview.removeRendererFrameCallback(this);
                EGLContext eglContext = EGL14.eglGetCurrentContext();
                final EglCore core = new EglCore(eglContext, 1);
                WorkerHandler.execute(new Runnable(){

                    @Override
                    public void run() {
                        EglWindowSurface surface = new EglWindowSurface(core, mSurfaceTexture);
                        surface.makeCurrent();
                        mSurfaceTexture.updateTexImage();
                        mSurfaceTexture.getTransformMatrix(mTransform);
                        boolean flip = SnapshotGlPictureRecorder.this.mEngine.getAngles().flip(Reference.VIEW, Reference.SENSOR);
                        float realScaleX = flip ? scaleY : scaleX;
                        float realScaleY = flip ? scaleX : scaleY;
                        float scaleTranslX = (1.0f - realScaleX) / 2.0f;
                        float scaleTranslY = (1.0f - realScaleY) / 2.0f;
                        Matrix.translateM((float[])mTransform, (int)0, (float)scaleTranslX, (float)scaleTranslY, (float)0.0f);
                        Matrix.scaleM((float[])mTransform, (int)0, (float)realScaleX, (float)realScaleY, (float)1.0f);
                        Matrix.translateM((float[])mTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
                        Matrix.rotateM((float[])mTransform, (int)0, (float)(-SnapshotGlPictureRecorder.this.mResult.rotation), (float)0.0f, (float)0.0f, (float)1.0f);
                        SnapshotGlPictureRecorder.this.mResult.rotation = 0;
                        if (SnapshotGlPictureRecorder.this.mResult.facing == Facing.FRONT) {
                            Matrix.scaleM((float[])mTransform, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
                        }
                        Matrix.translateM((float[])mTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
                        if (SnapshotGlPictureRecorder.this.mHasOverlay) {
                            try {
                                Canvas surfaceCanvas = mOverlaySurface.lockCanvas(null);
                                surfaceCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                                SnapshotGlPictureRecorder.this.mOverlay.drawOn(Overlay.Target.PICTURE_SNAPSHOT, surfaceCanvas);
                                mOverlaySurface.unlockCanvasAndPost(surfaceCanvas);
                            }
                            catch (Surface.OutOfResourcesException e) {
                                LOG.w(new Object[]{"Got Surface.OutOfResourcesException while drawing picture overlays", e});
                            }
                            mOverlaySurfaceTexture.updateTexImage();
                            mOverlaySurfaceTexture.getTransformMatrix(mOverlayTransform);
                            int rotation = SnapshotGlPictureRecorder.this.mEngine.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
                            Matrix.translateM((float[])mOverlayTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
                            Matrix.rotateM((float[])mOverlayTransform, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                            Matrix.scaleM((float[])mOverlayTransform, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
                            Matrix.translateM((float[])mOverlayTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
                        }
                        mViewport.drawFrame(mTextureId, mTransform);
                        if (SnapshotGlPictureRecorder.this.mHasOverlay) {
                            mViewport.drawFrame(mOverlayTextureId, mOverlayTransform);
                        }
                        SnapshotGlPictureRecorder.this.mResult.data = surface.saveFrameTo(Bitmap.CompressFormat.JPEG);
                        SnapshotGlPictureRecorder.this.mResult.format = 0;
                        mSurfaceTexture.releaseTexImage();
                        surface.release();
                        mViewport.release();
                        mSurfaceTexture.release();
                        if (SnapshotGlPictureRecorder.this.mHasOverlay) {
                            mOverlaySurface.release();
                            mOverlaySurfaceTexture.release();
                        }
                        core.release();
                        SnapshotGlPictureRecorder.this.dispatchResult();
                    }
                });
            }
        });
    }

    @Override
    protected void dispatchResult() {
        this.mEngine = null;
        this.mOutputRatio = null;
        super.dispatchResult();
    }
}

