/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.engine.Camera1Engine;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.internal.utils.CropHelper;
import com.otaliastudios.cameraview.internal.utils.RotationHelper;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class Snapshot1PictureRecorder
extends PictureRecorder {
    private static final String TAG = Snapshot1PictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private Camera1Engine mEngine1;
    private Camera mCamera;
    private AspectRatio mOutputRatio;
    private int mFormat;

    public Snapshot1PictureRecorder(@NonNull PictureResult.Stub stub, @NonNull Camera1Engine engine, @NonNull Camera camera, @NonNull AspectRatio outputRatio) {
        super(stub, engine);
        this.mEngine1 = engine;
        this.mCamera = camera;
        this.mOutputRatio = outputRatio;
        this.mFormat = camera.getParameters().getPreviewFormat();
    }

    @Override
    public void take() {
        this.mCamera.setOneShotPreviewCallback(new Camera.PreviewCallback(){

            public void onPreviewFrame(final @NonNull byte[] yuv, Camera camera) {
                Snapshot1PictureRecorder.this.dispatchOnShutter(false);
                final int sensorToOutput = Snapshot1PictureRecorder.this.mResult.rotation;
                final Size outputSize = Snapshot1PictureRecorder.this.mResult.size;
                final Size previewStreamSize = Snapshot1PictureRecorder.this.mEngine1.getPreviewStreamSize(Reference.SENSOR);
                if (previewStreamSize == null) {
                    throw new IllegalStateException("Preview stream size should never be null here.");
                }
                WorkerHandler.execute(new Runnable(){

                    @Override
                    public void run() {
                        byte[] data = RotationHelper.rotate(yuv, previewStreamSize, sensorToOutput);
                        YuvImage yuv2 = new YuvImage(data, Snapshot1PictureRecorder.this.mFormat, outputSize.getWidth(), outputSize.getHeight(), null);
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        Rect outputRect = CropHelper.computeCrop(outputSize, Snapshot1PictureRecorder.this.mOutputRatio);
                        yuv2.compressToJpeg(outputRect, 90, (OutputStream)stream);
                        data = stream.toByteArray();
                        Snapshot1PictureRecorder.this.mResult.data = data;
                        Snapshot1PictureRecorder.this.mResult.size = new Size(outputRect.width(), outputRect.height());
                        Snapshot1PictureRecorder.this.mResult.rotation = 0;
                        Snapshot1PictureRecorder.this.mResult.format = 0;
                        Snapshot1PictureRecorder.this.dispatchResult();
                    }
                });
                camera.setPreviewCallbackWithBuffer(null);
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)Snapshot1PictureRecorder.this.mEngine1);
                Snapshot1PictureRecorder.this.mEngine1.getFrameManager().setUp(ImageFormat.getBitsPerPixel((int)Snapshot1PictureRecorder.this.mFormat), previewStreamSize);
            }
        });
    }

    @Override
    protected void dispatchResult() {
        this.mEngine1 = null;
        this.mCamera = null;
        this.mOutputRatio = null;
        this.mFormat = 0;
        super.dispatchResult();
    }
}

