/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.exifinterface.media.ExifInterface;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.internal.utils.ExifHelper;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@RequiresApi(value=21)
public class Full2PictureRecorder
extends PictureRecorder
implements ImageReader.OnImageAvailableListener {
    private static final String TAG = Full2PictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int STATE_IDLE = 0;
    private static final int STATE_WAITING_FOCUS_LOCK = 1;
    private static final int STATE_WAITING_PRECAPTURE_START = 2;
    private static final int STATE_WAITING_PRECAPTURE_END = 3;
    private static final int STATE_WAITING_CAPTURE = 4;
    private static final int STATE_WAITING_IMAGE = 5;
    private static final int REQUEST_TAG = 2;
    private CameraCaptureSession mSession;
    private CaptureRequest.Builder mBuilder;
    private CameraCaptureSession.CaptureCallback mCallback;
    private ImageReader mPictureReader;
    private CaptureRequest.Builder mPictureBuilder;
    private boolean mStopPreviewBeforeCapture;
    private int mState = 0;

    public Full2PictureRecorder(@NonNull PictureResult.Stub stub, @Nullable PictureRecorder.PictureResultListener listener, @NonNull CameraCaptureSession session, @NonNull CaptureRequest.Builder builder, @NonNull CameraCaptureSession.CaptureCallback callback, @NonNull CaptureRequest.Builder pictureBuilder, @NonNull ImageReader pictureReader, boolean stopPreviewBeforeCapture) {
        super(stub, listener);
        this.mSession = session;
        this.mBuilder = builder;
        this.mCallback = callback;
        this.mPictureBuilder = pictureBuilder;
        this.mStopPreviewBeforeCapture = stopPreviewBeforeCapture;
        this.mPictureReader = pictureReader;
        this.mPictureReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, WorkerHandler.get().getHandler());
    }

    @Override
    public void take() {
        this.runFocusLock();
    }

    private void runFocusLock() {
        try {
            this.mState = 1;
            this.mBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.mSession.capture(this.mBuilder.build(), this.mCallback, null);
        }
        catch (CameraAccessException e) {
            this.mResult = null;
            this.mError = e;
            this.dispatchResult();
        }
    }

    private void runPrecapture() {
        try {
            this.mState = 2;
            this.mBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.mSession.capture(this.mBuilder.build(), this.mCallback, null);
        }
        catch (CameraAccessException e) {
            this.mResult = null;
            this.mError = e;
            this.dispatchResult();
        }
    }

    private void runCapture() {
        try {
            this.mPictureBuilder.setTag((Object)2);
            this.mPictureBuilder.addTarget(this.mPictureReader.getSurface());
            this.mPictureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.mResult.rotation);
            if (this.mStopPreviewBeforeCapture) {
                this.mSession.stopRepeating();
                this.mSession.abortCaptures();
            }
            this.mSession.capture(this.mPictureBuilder.build(), this.mCallback, null);
        }
        catch (CameraAccessException e) {
            this.mResult = null;
            this.mError = e;
            this.dispatchResult();
        }
    }

    public void onCaptureStarted(@NonNull CaptureRequest request) {
        if (request.getTag() == Integer.valueOf(2)) {
            this.dispatchOnShutter(false);
        }
    }

    public void onCaptureProgressed(@NonNull CaptureResult result) {
        this.process(result);
    }

    public void onCaptureCompleted(@NonNull CaptureResult result) {
        this.process(result);
    }

    private void process(@NonNull CaptureResult result) {
        switch (this.mState) {
            case 0: {
                break;
            }
            case 1: {
                Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                if (afState == null) {
                    this.runCapture();
                    break;
                }
                if (afState != 4 && afState != 5) break;
                Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (aeState == null || aeState == 2) {
                    this.mState = 4;
                    this.runCapture();
                    break;
                }
                this.runPrecapture();
                break;
            }
            case 2: {
                Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (aeState != null && aeState != 5 && aeState != 4) break;
                this.mState = 3;
                break;
            }
            case 3: {
                Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                if (aeState != null && aeState == 5) break;
                this.mState = 4;
                this.runCapture();
                break;
            }
            case 4: {
                if (!(result instanceof TotalCaptureResult) || result.getRequest().getTag() != Integer.valueOf(2)) break;
                this.mState = 5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onImageAvailable(ImageReader reader) {
        this.mState = 0;
        try (Image image = null;){
            image = reader.acquireNextImage();
            ByteBuffer buffer = image.getPlanes()[0].getBuffer();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.mResult.data = bytes;
        }
        this.mResult.format = 0;
        this.mResult.rotation = 0;
        try {
            ExifInterface exif = new ExifInterface((InputStream)new ByteArrayInputStream(this.mResult.data));
            int exifOrientation = exif.getAttributeInt("Orientation", 1);
            this.mResult.rotation = ExifHelper.readExifOrientation(exifOrientation);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.mSession.capture(this.mBuilder.build(), this.mCallback, null);
        }
        catch (CameraAccessException cameraAccessException) {
            // empty catch block
        }
        this.dispatchResult();
    }

    @Override
    protected void dispatchResult() {
        this.mState = 0;
        super.dispatchResult();
    }
}

