/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.hardware.Camera;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.internal.utils.ExifHelper;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Full1PictureRecorder
extends PictureRecorder {
    private static final String TAG = Full1PictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private Camera mCamera;

    public Full1PictureRecorder(@NonNull PictureResult.Stub stub, @Nullable PictureRecorder.PictureResultListener listener, @NonNull Camera camera) {
        super(stub, listener);
        this.mCamera = camera;
        Camera.Parameters params = this.mCamera.getParameters();
        params.setRotation(this.mResult.rotation);
        this.mCamera.setParameters(params);
    }

    @Override
    public void take() {
        this.mCamera.takePicture(new Camera.ShutterCallback(){

            public void onShutter() {
                Full1PictureRecorder.this.dispatchOnShutter(true);
            }
        }, null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                int exifRotation;
                try {
                    ExifInterface exif = new ExifInterface((InputStream)new ByteArrayInputStream(data));
                    int exifOrientation = exif.getAttributeInt("Orientation", 1);
                    exifRotation = ExifHelper.readExifOrientation(exifOrientation);
                }
                catch (IOException e) {
                    exifRotation = 0;
                }
                Full1PictureRecorder.this.mResult.format = 0;
                Full1PictureRecorder.this.mResult.data = data;
                Full1PictureRecorder.this.mResult.rotation = exifRotation;
                camera.startPreview();
                Full1PictureRecorder.this.dispatchResult();
            }
        });
    }

    @Override
    protected void dispatchResult() {
        this.mCamera = null;
        super.dispatchResult();
    }
}

