/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.utils;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import java.util.concurrent.LinkedBlockingQueue;

public class Pool<T> {
    private static final String TAG = Pool.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private int maxPoolSize;
    private int activeCount;
    private LinkedBlockingQueue<T> queue;
    private Factory<T> factory;
    private final Object lock = new Object();

    public Pool(int maxPoolSize, @NonNull Factory<T> factory) {
        this.maxPoolSize = maxPoolSize;
        this.queue = new LinkedBlockingQueue(maxPoolSize);
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.count() >= this.maxPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T get() {
        Object object = this.lock;
        synchronized (object) {
            T item = this.queue.poll();
            if (item != null) {
                ++this.activeCount;
                LOG.v("GET - Reusing recycled item.", this);
                return item;
            }
            if (this.isEmpty()) {
                LOG.v("GET - Returning null. Too much items requested.", this);
                return null;
            }
            ++this.activeCount;
            LOG.v("GET - Creating a new item.", this);
            return this.factory.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle(@NonNull T item) {
        Object object = this.lock;
        synchronized (object) {
            LOG.v("RECYCLE - Recycling item.", this);
            if (--this.activeCount < 0) {
                throw new IllegalStateException("Trying to recycle an item which makes activeCount < 0.This means that this or some previous items being recycled were not coming from this pool, or some item was recycled more than once. " + this);
            }
            if (!this.queue.offer(item)) {
                throw new IllegalStateException("Trying to recycle an item while the queue is full. This means that this or some previous items being recycled were not coming from this pool, or some item was recycled more than once. " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int count() {
        Object object = this.lock;
        synchronized (object) {
            return this.activeCount() + this.recycledCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int activeCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int recycledCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.size();
        }
    }

    @NonNull
    public String toString() {
        return this.getClass().getSimpleName() + " - count:" + this.count() + ", active:" + this.activeCount() + ", recycled:" + this.recycledCount();
    }

    public static interface Factory<T> {
        public T create();
    }
}

