/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.utils;

import android.content.Context;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

public class OrientationHelper {
    @VisibleForTesting
    final OrientationEventListener mListener;
    private final Callback mCallback;
    private int mDeviceOrientation = -1;
    private int mDisplayOffset = -1;

    public OrientationHelper(@NonNull Context context, @NonNull Callback callback) {
        this.mCallback = callback;
        this.mListener = new OrientationEventListener(context.getApplicationContext(), 3){

            public void onOrientationChanged(int orientation) {
                int or = 0;
                if (orientation == -1) {
                    or = OrientationHelper.this.mDeviceOrientation != -1 ? OrientationHelper.this.mDeviceOrientation : 0;
                } else if (orientation >= 315 || orientation < 45) {
                    or = 0;
                } else if (orientation >= 45 && orientation < 135) {
                    or = 90;
                } else if (orientation >= 135 && orientation < 225) {
                    or = 180;
                } else if (orientation >= 225 && orientation < 315) {
                    or = 270;
                }
                if (or != OrientationHelper.this.mDeviceOrientation) {
                    OrientationHelper.this.mDeviceOrientation = or;
                    OrientationHelper.this.mCallback.onDeviceOrientationChanged(OrientationHelper.this.mDeviceOrientation);
                }
            }
        };
    }

    public void enable(@NonNull Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        switch (display.getRotation()) {
            case 0: {
                this.mDisplayOffset = 0;
                break;
            }
            case 1: {
                this.mDisplayOffset = 90;
                break;
            }
            case 2: {
                this.mDisplayOffset = 180;
                break;
            }
            case 3: {
                this.mDisplayOffset = 270;
                break;
            }
            default: {
                this.mDisplayOffset = 0;
            }
        }
        this.mListener.enable();
    }

    public void disable() {
        this.mListener.disable();
        this.mDisplayOffset = -1;
        this.mDeviceOrientation = -1;
    }

    public int getDeviceOrientation() {
        return this.mDeviceOrientation;
    }

    public int getDisplayOffset() {
        return this.mDisplayOffset;
    }

    public static interface Callback {
        public void onDeviceOrientationChanged(int var1);
    }
}

