/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.utils;

import androidx.annotation.NonNull;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Op<T> {
    private CountDownLatch mLatch;
    private T mResult;
    private int mCount;

    public Op() {
    }

    public Op(boolean startListening) {
        if (startListening) {
            this.listen();
        }
    }

    private boolean isListening() {
        return this.mLatch != null;
    }

    public void start() {
        if (!this.isListening()) {
            ++this.mCount;
        }
    }

    public void end(T result) {
        if (this.mCount > 0) {
            --this.mCount;
            return;
        }
        if (this.isListening()) {
            this.mResult = result;
            this.mLatch.countDown();
        }
    }

    public void listen() {
        if (this.isListening()) {
            throw new RuntimeException("Should not happen.");
        }
        this.mResult = null;
        this.mLatch = new CountDownLatch(1);
    }

    public T await(long millis) {
        return this.await(millis, TimeUnit.MILLISECONDS);
    }

    public T await() {
        return this.await(1L, TimeUnit.MINUTES);
    }

    private T await(long time, @NonNull TimeUnit unit) {
        try {
            this.mLatch.await(time, unit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        T result = this.mResult;
        this.mResult = null;
        this.mLatch = null;
        return result;
    }
}

