/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.utils;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;

public class CropHelper {
    @NonNull
    public static Rect computeCrop(@NonNull Size currentSize, @NonNull AspectRatio targetRatio) {
        int x;
        int y;
        int width;
        int height;
        int currentWidth = currentSize.getWidth();
        int currentHeight = currentSize.getHeight();
        if (targetRatio.matches(currentSize)) {
            return new Rect(0, 0, currentWidth, currentHeight);
        }
        AspectRatio currentRatio = AspectRatio.of(currentWidth, currentHeight);
        if (currentRatio.toFloat() > targetRatio.toFloat()) {
            height = currentHeight;
            width = (int)((float)height * targetRatio.toFloat());
            y = 0;
            x = (currentWidth - width) / 2;
        } else {
            width = currentWidth;
            height = (int)((float)width / targetRatio.toFloat());
            y = (currentHeight - height) / 2;
            x = 0;
        }
        return new Rect(x, y, x + width, y + height);
    }
}

