/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.utils;

import android.annotation.SuppressLint;
import android.media.CamcorderProfile;
import android.os.Build;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.size.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CamcorderProfiles {
    @SuppressLint(value={"UseSparseArrays"})
    private static Map<Size, Integer> sizeToProfileMap = new HashMap<Size, Integer>();

    @NonNull
    public static CamcorderProfile get(@NonNull String cameraId, @NonNull Size targetSize) {
        try {
            int camera1Id = Integer.parseInt(cameraId);
            return CamcorderProfiles.get(camera1Id, targetSize);
        }
        catch (NumberFormatException e) {
            return CamcorderProfile.get((int)0);
        }
    }

    @NonNull
    public static CamcorderProfile get(int cameraId, @NonNull Size targetSize) {
        final long targetArea = (long)targetSize.getWidth() * (long)targetSize.getHeight();
        ArrayList<Size> sizes = new ArrayList<Size>(sizeToProfileMap.keySet());
        Collections.sort(sizes, new Comparator<Size>(){

            @Override
            public int compare(Size s1, Size s2) {
                long a2;
                long a1 = Math.abs((long)(s1.getWidth() * s1.getHeight()) - targetArea);
                return a1 < (a2 = Math.abs((long)(s2.getWidth() * s2.getHeight()) - targetArea)) ? -1 : (a1 == a2 ? 0 : 1);
            }
        });
        while (sizes.size() > 0) {
            Size candidate = (Size)sizes.remove(0);
            int quality = sizeToProfileMap.get(candidate);
            if (!CamcorderProfile.hasProfile((int)cameraId, (int)quality)) continue;
            return CamcorderProfile.get((int)cameraId, (int)quality);
        }
        return CamcorderProfile.get((int)cameraId, (int)0);
    }

    static {
        sizeToProfileMap.put(new Size(176, 144), 2);
        sizeToProfileMap.put(new Size(320, 240), 7);
        sizeToProfileMap.put(new Size(352, 288), 3);
        sizeToProfileMap.put(new Size(720, 480), 4);
        sizeToProfileMap.put(new Size(1280, 720), 5);
        sizeToProfileMap.put(new Size(1920, 1080), 6);
        if (Build.VERSION.SDK_INT >= 21) {
            sizeToProfileMap.put(new Size(3840, 2160), 8);
        }
    }
}

