/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.egl;

import android.opengl.GLES20;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.internal.egl.EglElement;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class EglViewport
extends EglElement {
    private static final CameraLogger LOG = CameraLogger.create(EglViewport.class.getSimpleName());
    private static final String SIMPLE_VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    private static final String SIMPLE_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final float[] FULL_RECTANGLE_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] FULL_RECTANGLE_TEX_COORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static final int VERTEX_COUNT = FULL_RECTANGLE_COORDS.length / 2;
    private FloatBuffer mVertexCoordinatesArray = EglViewport.floatBuffer(FULL_RECTANGLE_COORDS);
    private FloatBuffer mTextureCoordinatesArray = EglViewport.floatBuffer(FULL_RECTANGLE_TEX_COORDS);
    private int mProgramHandle = EglViewport.createProgram("uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n");
    private int mTextureTarget = 36197;
    private int muMVPMatrixLocation;
    private int muTexMatrixLocation;
    private int maPositionLocation = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
    private int maTextureCoordLocation;

    public EglViewport() {
        EglViewport.checkLocation(this.maPositionLocation, "aPosition");
        this.maTextureCoordLocation = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        EglViewport.checkLocation(this.maTextureCoordLocation, "aTextureCoord");
        this.muMVPMatrixLocation = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uMVPMatrix");
        EglViewport.checkLocation(this.muMVPMatrixLocation, "uMVPMatrix");
        this.muTexMatrixLocation = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
        EglViewport.checkLocation(this.muTexMatrixLocation, "uTexMatrix");
    }

    public void release(boolean doEglCleanup) {
        if (doEglCleanup) {
            GLES20.glDeleteProgram((int)this.mProgramHandle);
        }
        this.mProgramHandle = -1;
    }

    public void release() {
        this.release(true);
    }

    public int createTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        EglViewport.check("glGenTextures");
        int texId = textures[0];
        GLES20.glBindTexture((int)this.mTextureTarget, (int)texId);
        EglViewport.check("glBindTexture " + texId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        EglViewport.check("glTexParameter");
        return texId;
    }

    public void drawFrame(int textureId, float[] textureMatrix) {
        this.drawFrame(textureId, textureMatrix, this.mVertexCoordinatesArray, this.mTextureCoordinatesArray);
    }

    private void drawFrame(int textureId, float[] textureMatrix, FloatBuffer vertexBuffer, FloatBuffer texBuffer) {
        EglViewport.check("draw start");
        GLES20.glUseProgram((int)this.mProgramHandle);
        EglViewport.check("glUseProgram");
        GLES20.glDisable((int)2884);
        GLES20.glDisable((int)2929);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)textureId);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLocation, (int)1, (boolean)false, (float[])IDENTITY_MATRIX, (int)0);
        EglViewport.check("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLocation, (int)1, (boolean)false, (float[])textureMatrix, (int)0);
        EglViewport.check("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.maPositionLocation);
        EglViewport.check("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maPositionLocation, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)vertexBuffer);
        EglViewport.check("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLocation);
        EglViewport.check("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLocation, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)texBuffer);
        EglViewport.check("glVertexAttribPointer");
        GLES20.glDrawArrays((int)5, (int)0, (int)VERTEX_COUNT);
        EglViewport.check("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.maPositionLocation);
        GLES20.glDisableVertexAttribArray((int)this.maTextureCoordLocation);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }
}

