/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.egl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.otaliastudios.cameraview.CameraLogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

class EglElement {
    private static final CameraLogger LOG = CameraLogger.create(EglElement.class.getSimpleName());
    protected static final float[] IDENTITY_MATRIX = new float[16];

    EglElement() {
    }

    protected static void check(String opName) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String message = LOG.e("Error during", opName, "glError 0x", Integer.toHexString(error));
            throw new RuntimeException(message);
        }
    }

    protected static void checkLocation(int location, String label) {
        if (location < 0) {
            String message = LOG.e("Unable to locate", label, "in program");
            throw new RuntimeException(message);
        }
    }

    protected static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        EglElement.check("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            LOG.e("Could not compile shader", shaderType, ":", GLES20.glGetShaderInfoLog((int)shader));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    protected static int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = EglElement.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = EglElement.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        EglElement.check("glCreateProgram");
        if (program == 0) {
            LOG.e("Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        EglElement.check("glAttachShader");
        GLES20.glAttachShader((int)program, (int)pixelShader);
        EglElement.check("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            LOG.e("Could not link program:", GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        return program;
    }

    protected static FloatBuffer floatBuffer(float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

