/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.gesture;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.gesture.GestureType;

public enum GestureAction {
    NONE(0, GestureType.ONE_SHOT),
    AUTO_FOCUS(1, GestureType.ONE_SHOT),
    TAKE_PICTURE(2, GestureType.ONE_SHOT),
    ZOOM(3, GestureType.CONTINUOUS),
    EXPOSURE_CORRECTION(4, GestureType.CONTINUOUS);

    static final GestureAction DEFAULT_PINCH;
    static final GestureAction DEFAULT_TAP;
    static final GestureAction DEFAULT_LONG_TAP;
    static final GestureAction DEFAULT_SCROLL_HORIZONTAL;
    static final GestureAction DEFAULT_SCROLL_VERTICAL;
    private int value;
    private GestureType type;

    private GestureAction(int value, GestureType type) {
        this.value = value;
        this.type = type;
    }

    int value() {
        return this.value;
    }

    @NonNull
    GestureType type() {
        return this.type;
    }

    @Nullable
    static GestureAction fromValue(int value) {
        GestureAction[] list;
        for (GestureAction action : list = GestureAction.values()) {
            if (action.value() != value) continue;
            return action;
        }
        return null;
    }

    static {
        DEFAULT_PINCH = NONE;
        DEFAULT_TAP = NONE;
        DEFAULT_LONG_TAP = NONE;
        DEFAULT_SCROLL_HORIZONTAL = NONE;
        DEFAULT_SCROLL_VERTICAL = NONE;
    }
}

