/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.frame;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.frame.Frame;
import com.otaliastudios.cameraview.size.Size;
import java.util.concurrent.LinkedBlockingQueue;

public class FrameManager {
    private static final String TAG = FrameManager.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private final int mPoolSize;
    private int mBufferSize = -1;
    private LinkedBlockingQueue<Frame> mFrameQueue;
    private LinkedBlockingQueue<byte[]> mBufferQueue;
    private BufferCallback mBufferCallback;
    private final int mBufferMode;
    private static final int BUFFER_MODE_DISPATCH = 0;
    private static final int BUFFER_MODE_ENQUEUE = 1;

    public FrameManager(int poolSize, @Nullable BufferCallback callback) {
        this.mPoolSize = poolSize;
        this.mFrameQueue = new LinkedBlockingQueue(this.mPoolSize);
        if (callback != null) {
            this.mBufferCallback = callback;
            this.mBufferMode = 0;
        } else {
            this.mBufferQueue = new LinkedBlockingQueue(this.mPoolSize);
            this.mBufferMode = 1;
        }
    }

    public int setUp(int bitsPerPixel, @NonNull Size previewSize) {
        long sizeInBits = previewSize.getHeight() * previewSize.getWidth() * bitsPerPixel;
        this.mBufferSize = (int)Math.ceil((double)sizeInBits / 8.0);
        for (int i = 0; i < this.mPoolSize; ++i) {
            if (this.mBufferMode == 0) {
                this.mBufferCallback.onBufferAvailable(new byte[this.mBufferSize]);
                continue;
            }
            this.mBufferQueue.offer(new byte[this.mBufferSize]);
        }
        return this.mBufferSize;
    }

    @Nullable
    public byte[] getBuffer() {
        if (this.mBufferMode != 1) {
            throw new IllegalStateException("Can't call getBuffer() when not in BUFFER_MODE_ENQUEUE.");
        }
        return this.mBufferQueue.poll();
    }

    public void onBufferUnused(@NonNull byte[] buffer) {
        if (this.mBufferMode != 1) {
            throw new IllegalStateException("Can't call onBufferUnused() when not in BUFFER_MODE_ENQUEUE.");
        }
        this.mBufferQueue.offer(buffer);
    }

    @NonNull
    public Frame getFrame(@NonNull byte[] data, long time, int rotation, @NonNull Size previewSize, int previewFormat) {
        Frame frame = this.mFrameQueue.poll();
        if (frame != null) {
            LOG.v("getFrame for time:", time, "RECYCLING.", "Data:", data != null);
        } else {
            LOG.v("getFrame for time:", time, "CREATING.", "Data:", data != null);
            frame = new Frame(this);
        }
        frame.set(data, time, rotation, previewSize, previewFormat);
        return frame;
    }

    public void release() {
        LOG.w("Releasing all frames!");
        for (Frame frame : this.mFrameQueue) {
            frame.releaseManager();
            frame.release();
        }
        this.mFrameQueue.clear();
        if (this.mBufferMode == 1) {
            this.mBufferQueue.clear();
        }
        this.mBufferSize = -1;
    }

    void onFrameReleased(@NonNull Frame frame) {
        byte[] buffer = frame.getData();
        boolean willRecycle = this.mFrameQueue.offer(frame);
        if (!willRecycle) {
            frame.releaseManager();
        } else {
            int currSize = buffer.length;
            int reqSize = this.mBufferSize;
            if (currSize == reqSize) {
                if (this.mBufferMode == 0) {
                    this.mBufferCallback.onBufferAvailable(buffer);
                } else {
                    this.mBufferQueue.offer(buffer);
                }
            }
        }
    }

    public static interface BufferCallback {
        public void onBufferAvailable(@NonNull byte[] var1);
    }
}

