/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.frame;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.frame.FrameManager;
import com.otaliastudios.cameraview.size.Size;

public class Frame {
    private static final String TAG = Frame.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    @VisibleForTesting
    FrameManager mManager;
    private byte[] mData = null;
    private long mTime = -1L;
    private long mLastTime = -1L;
    private int mRotation = 0;
    private Size mSize = null;
    private int mFormat = -1;

    Frame(@NonNull FrameManager manager) {
        this.mManager = manager;
    }

    private boolean isAlive() {
        return this.mData != null;
    }

    private void ensureAlive() {
        if (!this.isAlive()) {
            LOG.e("Frame is dead! time:", this.mTime, "lastTime:", this.mLastTime);
            throw new RuntimeException("You should not access a released frame. If this frame was passed to a FrameProcessor, you can only use its contents synchronously,for the duration of the process() method.");
        }
    }

    void set(@NonNull byte[] data, long time, int rotation, @NonNull Size size, int format) {
        this.mData = data;
        this.mTime = time;
        this.mLastTime = time;
        this.mRotation = rotation;
        this.mSize = size;
        this.mFormat = format;
    }

    public boolean equals(Object obj) {
        return obj instanceof Frame && ((Frame)obj).mTime == this.mTime;
    }

    @NonNull
    public Frame freeze() {
        this.ensureAlive();
        byte[] data = new byte[this.mData.length];
        System.arraycopy(this.mData, 0, data, 0, this.mData.length);
        Frame other = new Frame(this.mManager);
        other.set(data, this.mTime, this.mRotation, this.mSize, this.mFormat);
        return other;
    }

    public void release() {
        if (!this.isAlive()) {
            return;
        }
        LOG.v("Frame with time", this.mTime, "is being released. Has manager:", this.mManager != null);
        if (this.mManager != null) {
            this.mManager.onFrameReleased(this);
        }
        this.mData = null;
        this.mRotation = 0;
        this.mTime = -1L;
        this.mSize = null;
        this.mFormat = -1;
    }

    void releaseManager() {
        this.mManager = null;
    }

    @NonNull
    public byte[] getData() {
        this.ensureAlive();
        return this.mData;
    }

    public long getTime() {
        this.ensureAlive();
        return this.mTime;
    }

    public int getRotation() {
        this.ensureAlive();
        return this.mRotation;
    }

    @NonNull
    public Size getSize() {
        this.ensureAlive();
        return this.mSize;
    }

    public int getFormat() {
        this.ensureAlive();
        return this.mFormat;
    }
}

