/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.controls.Control;
import com.otaliastudios.cameraview.controls.Engine;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class Mapper {
    private static Mapper CAMERA1;
    private static Mapper CAMERA2;

    public static Mapper get(@NonNull Engine engine) {
        if (engine == Engine.CAMERA1) {
            if (CAMERA1 == null) {
                CAMERA1 = new Camera1Mapper();
            }
            return CAMERA1;
        }
        if (engine == Engine.CAMERA2 && Build.VERSION.SDK_INT >= 21) {
            if (CAMERA2 == null) {
                CAMERA2 = new Camera2Mapper();
            }
            return CAMERA2;
        }
        throw new IllegalArgumentException("Unknown engine or unsupported API level.");
    }

    private Mapper() {
    }

    public abstract <T> T map(Flash var1);

    public abstract <T> T map(Facing var1);

    public abstract <T> T map(WhiteBalance var1);

    public abstract <T> T map(Hdr var1);

    public abstract <T> Flash unmapFlash(T var1);

    public abstract <T> Facing unmapFacing(T var1);

    public abstract <T> WhiteBalance unmapWhiteBalance(T var1);

    public abstract <T> Hdr unmapHdr(T var1);

    protected <C extends Control, T> C reverseLookup(HashMap<C, T> map, T object) {
        for (Control value : map.keySet()) {
            if (!object.equals(map.get(value))) continue;
            return (C)value;
        }
        return null;
    }

    protected <C extends Control, T> C reverseListLookup(HashMap<C, List<T>> map, T object) {
        for (Control value : map.keySet()) {
            List<T> list = map.get(value);
            if (list == null) continue;
            for (T candidate : list) {
                if (!object.equals(candidate)) continue;
                return (C)value;
            }
        }
        return null;
    }

    @RequiresApi(value=21)
    private static class Camera2Mapper
    extends Mapper {
        private static final HashMap<Flash, List<Integer>> FLASH = new HashMap();
        private static final HashMap<Facing, Integer> FACING = new HashMap();
        private static final HashMap<WhiteBalance, Integer> WB = new HashMap();
        private static final HashMap<Hdr, Integer> HDR = new HashMap();

        private Camera2Mapper() {
        }

        @Override
        public <T> T map(Flash flash) {
            return (T)FLASH.get(flash);
        }

        @Override
        public <T> T map(Facing facing) {
            return (T)FACING.get(facing);
        }

        @Override
        public <T> T map(WhiteBalance whiteBalance) {
            return (T)WB.get(whiteBalance);
        }

        @Override
        public <T> T map(Hdr hdr) {
            return (T)HDR.get(hdr);
        }

        @Override
        public <T> Flash unmapFlash(T cameraConstant) {
            return this.reverseListLookup(FLASH, (Integer)cameraConstant);
        }

        @Override
        public <T> Facing unmapFacing(T cameraConstant) {
            return this.reverseLookup(FACING, (Integer)cameraConstant);
        }

        @Override
        public <T> WhiteBalance unmapWhiteBalance(T cameraConstant) {
            return this.reverseLookup(WB, (Integer)cameraConstant);
        }

        @Override
        public <T> Hdr unmapHdr(T cameraConstant) {
            return this.reverseLookup(HDR, (Integer)cameraConstant);
        }

        static {
            FLASH.put(Flash.OFF, Arrays.asList(1, 0));
            FLASH.put(Flash.TORCH, Arrays.asList(1, 0));
            FLASH.put(Flash.AUTO, Arrays.asList(2, 4));
            FLASH.put(Flash.ON, Collections.singletonList(3));
            FACING.put(Facing.BACK, 1);
            FACING.put(Facing.FRONT, 0);
            WB.put(WhiteBalance.AUTO, 1);
            WB.put(WhiteBalance.CLOUDY, 6);
            WB.put(WhiteBalance.DAYLIGHT, 5);
            WB.put(WhiteBalance.FLUORESCENT, 3);
            WB.put(WhiteBalance.INCANDESCENT, 2);
            HDR.put(Hdr.OFF, 0);
            HDR.put(Hdr.ON, 18);
        }
    }

    private static class Camera1Mapper
    extends Mapper {
        private static final HashMap<Flash, String> FLASH = new HashMap();
        private static final HashMap<WhiteBalance, String> WB = new HashMap();
        private static final HashMap<Facing, Integer> FACING = new HashMap();
        private static final HashMap<Hdr, String> HDR = new HashMap();

        private Camera1Mapper() {
        }

        @Override
        public <T> T map(Flash flash) {
            return (T)FLASH.get(flash);
        }

        @Override
        public <T> T map(Facing facing) {
            return (T)FACING.get(facing);
        }

        @Override
        public <T> T map(WhiteBalance whiteBalance) {
            return (T)WB.get(whiteBalance);
        }

        @Override
        public <T> T map(Hdr hdr) {
            return (T)HDR.get(hdr);
        }

        @Override
        public <T> Flash unmapFlash(T cameraConstant) {
            return this.reverseLookup(FLASH, (String)cameraConstant);
        }

        @Override
        public <T> Facing unmapFacing(T cameraConstant) {
            return this.reverseLookup(FACING, (Integer)cameraConstant);
        }

        @Override
        public <T> WhiteBalance unmapWhiteBalance(T cameraConstant) {
            return this.reverseLookup(WB, (String)cameraConstant);
        }

        @Override
        public <T> Hdr unmapHdr(T cameraConstant) {
            return this.reverseLookup(HDR, (String)cameraConstant);
        }

        static {
            FLASH.put(Flash.OFF, "off");
            FLASH.put(Flash.ON, "on");
            FLASH.put(Flash.AUTO, "auto");
            FLASH.put(Flash.TORCH, "torch");
            FACING.put(Facing.BACK, 0);
            FACING.put(Facing.FRONT, 1);
            WB.put(WhiteBalance.AUTO, "auto");
            WB.put(WhiteBalance.INCANDESCENT, "incandescent");
            WB.put(WhiteBalance.FLUORESCENT, "fluorescent");
            WB.put(WhiteBalance.DAYLIGHT, "daylight");
            WB.put(WhiteBalance.CLOUDY, "cloudy-daylight");
            HDR.put(Hdr.OFF, "auto");
            if (Build.VERSION.SDK_INT >= 17) {
                HDR.put(Hdr.ON, "hdr");
            } else {
                HDR.put(Hdr.ON, "hdr");
            }
        }
    }
}

