/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.exifinterface.media.ExifInterface;
import com.otaliastudios.cameraview.BitmapCallback;
import com.otaliastudios.cameraview.FileCallback;
import com.otaliastudios.cameraview.controls.Engine;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.engine.Mapper;
import com.otaliastudios.cameraview.internal.utils.ExifHelper;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CameraUtils {
    public static boolean hasCameras(@NonNull Context context) {
        PackageManager manager = context.getPackageManager();
        return manager.hasSystemFeature("android.hardware.camera") || manager.hasSystemFeature("android.hardware.camera.front");
    }

    public static boolean hasCameraFacing(@NonNull Context context, @NonNull Facing facing) {
        int internal = (Integer)Mapper.get(Engine.CAMERA1).map(facing);
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != internal) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @WorkerThread
    @SuppressLint(value={"NewApi"})
    public static File writeToFile(@NonNull byte[] data, @NonNull File file) {
        if (file.exists() && !file.delete()) {
            return null;
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            ((OutputStream)stream).write(data);
            ((OutputStream)stream).flush();
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void writeToFile(final @NonNull byte[] data, final @NonNull File file, final @NonNull FileCallback callback) {
        final Handler ui = new Handler();
        WorkerHandler.execute(new Runnable(){

            @Override
            public void run() {
                final File result = CameraUtils.writeToFile(data, file);
                ui.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFileReady(result);
                    }
                });
            }
        });
    }

    @Nullable
    @WorkerThread
    public static Bitmap decodeBitmap(@NonNull byte[] source) {
        return CameraUtils.decodeBitmap(source, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static void decodeBitmap(@NonNull byte[] source, @NonNull BitmapCallback callback) {
        CameraUtils.decodeBitmap(source, Integer.MAX_VALUE, Integer.MAX_VALUE, callback);
    }

    public static void decodeBitmap(@NonNull byte[] source, int maxWidth, int maxHeight, @NonNull BitmapCallback callback) {
        CameraUtils.decodeBitmap(source, maxWidth, maxHeight, new BitmapFactory.Options(), callback);
    }

    public static void decodeBitmap(@NonNull byte[] source, int maxWidth, int maxHeight, @NonNull BitmapFactory.Options options, @NonNull BitmapCallback callback) {
        CameraUtils.decodeBitmap(source, maxWidth, maxHeight, options, -1, callback);
    }

    static void decodeBitmap(final @NonNull byte[] source, final int maxWidth, final int maxHeight, final @NonNull BitmapFactory.Options options, final int rotation, final @NonNull BitmapCallback callback) {
        final Handler ui = new Handler();
        WorkerHandler.execute(new Runnable(){

            @Override
            public void run() {
                final Bitmap bitmap = CameraUtils.decodeBitmap(source, maxWidth, maxHeight, options, rotation);
                ui.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onBitmapReady(bitmap);
                    }
                });
            }
        });
    }

    @Nullable
    @WorkerThread
    public static Bitmap decodeBitmap(@NonNull byte[] source, int maxWidth, int maxHeight) {
        return CameraUtils.decodeBitmap(source, maxWidth, maxHeight, new BitmapFactory.Options());
    }

    @Nullable
    @WorkerThread
    public static Bitmap decodeBitmap(@NonNull byte[] source, int maxWidth, int maxHeight, @NonNull BitmapFactory.Options options) {
        return CameraUtils.decodeBitmap(source, maxWidth, maxHeight, options, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Bitmap decodeBitmap(@NonNull byte[] source, int maxWidth, int maxHeight, @NonNull BitmapFactory.Options options, int rotation) {
        Bitmap bitmap;
        boolean flip;
        int orientation;
        if (maxWidth <= 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        if (maxHeight <= 0) {
            maxHeight = Integer.MAX_VALUE;
        }
        if (rotation == -1) {
            ByteArrayInputStream stream = null;
            try {
                stream = new ByteArrayInputStream(source);
                ExifInterface exif = new ExifInterface((InputStream)stream);
                int exifOrientation = exif.getAttributeInt("Orientation", 1);
                orientation = ExifHelper.readExifOrientation(exifOrientation);
                flip = exifOrientation == 2 || exifOrientation == 4 || exifOrientation == 5 || exifOrientation == 7;
            }
            catch (IOException e) {
                e.printStackTrace();
                orientation = 0;
                flip = false;
            }
            finally {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            orientation = rotation;
            flip = false;
        }
        try {
            if (maxWidth < Integer.MAX_VALUE || maxHeight < Integer.MAX_VALUE) {
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeByteArray((byte[])source, (int)0, (int)source.length, (BitmapFactory.Options)options);
                int outHeight = options.outHeight;
                int outWidth = options.outWidth;
                if (orientation % 180 != 0) {
                    outHeight = options.outWidth;
                    outWidth = options.outHeight;
                }
                options.inSampleSize = CameraUtils.computeSampleSize(outWidth, outHeight, maxWidth, maxHeight);
                options.inJustDecodeBounds = false;
                bitmap = BitmapFactory.decodeByteArray((byte[])source, (int)0, (int)source.length, (BitmapFactory.Options)options);
            } else {
                bitmap = BitmapFactory.decodeByteArray((byte[])source, (int)0, (int)source.length);
            }
            if (orientation != 0 || flip) {
                Matrix matrix = new Matrix();
                matrix.setRotate((float)orientation);
                Bitmap temp = bitmap;
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                temp.recycle();
            }
        }
        catch (OutOfMemoryError e) {
            bitmap = null;
        }
        return bitmap;
    }

    private static int computeSampleSize(int width, int height, int maxWidth, int maxHeight) {
        int inSampleSize = 1;
        if (height > maxHeight || width > maxWidth) {
            while (height / inSampleSize >= maxHeight || width / inSampleSize >= maxWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

