/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.CameraLogger;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

class WorkerHandler {
    private static final CameraLogger LOG = CameraLogger.create(WorkerHandler.class.getSimpleName());
    private static final ConcurrentHashMap<String, WeakReference<WorkerHandler>> sCache = new ConcurrentHashMap(4);
    private HandlerThread mThread;
    private Handler mHandler;

    @NonNull
    public static WorkerHandler get(@NonNull String name) {
        if (sCache.containsKey(name)) {
            HandlerThread thread;
            WorkerHandler cached = (WorkerHandler)sCache.get(name).get();
            if (cached != null && (thread = cached.mThread).isAlive() && !thread.isInterrupted()) {
                LOG.w("get:", "Reusing cached worker handler.", name);
                return cached;
            }
            LOG.w("get:", "Thread reference died, removing.", name);
            sCache.remove(name);
        }
        LOG.i("get:", "Creating new handler.", name);
        WorkerHandler handler = new WorkerHandler(name);
        sCache.put(name, new WeakReference<WorkerHandler>(handler));
        return handler;
    }

    public static void run(@NonNull Runnable action) {
        WorkerHandler.get("FallbackCameraThread").post(action);
    }

    private WorkerHandler(@NonNull String name) {
        this.mThread = new HandlerThread(name);
        this.mThread.setDaemon(true);
        this.mThread.start();
        this.mHandler = new Handler(this.mThread.getLooper());
    }

    public Handler get() {
        return this.mHandler;
    }

    public void post(@NonNull Runnable runnable) {
        this.mHandler.post(runnable);
    }

    @NonNull
    public HandlerThread getThread() {
        return this.mThread;
    }

    @NonNull
    public Looper getLooper() {
        return this.mThread.getLooper();
    }

    static void destroy() {
        for (String key : sCache.keySet()) {
            WeakReference<WorkerHandler> ref = sCache.get(key);
            WorkerHandler handler = (WorkerHandler)ref.get();
            if (handler != null && handler.getThread().isAlive()) {
                handler.getThread().interrupt();
            }
            ref.clear();
        }
        sCache.clear();
    }
}

