/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.VideoResult;

abstract class VideoRecorder {
    VideoResult mResult;
    VideoResultListener mListener;

    VideoRecorder(@NonNull VideoResult stub, @Nullable VideoResultListener listener) {
        this.mResult = stub;
        this.mListener = listener;
    }

    abstract void start();

    abstract void stop();

    protected void dispatchResult() {
        if (this.mListener != null) {
            this.mListener.onVideoResult(this.mResult);
            this.mListener = null;
            this.mResult = null;
        }
    }

    static interface VideoResultListener {
        public void onVideoResult(@Nullable VideoResult var1);
    }
}

