/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.MediaEncoder;
import com.otaliastudios.cameraview.MediaEncoderEngine;
import java.io.IOException;

@RequiresApi(api=18)
abstract class VideoMediaEncoder<C extends Config>
extends MediaEncoder {
    protected C mConfig;
    protected Surface mSurface;
    protected int mFrameNum = -1;

    VideoMediaEncoder(@NonNull C config) {
        this.mConfig = config;
    }

    @Override
    @NonNull
    String getName() {
        return "VideoEncoder";
    }

    @Override
    @EncoderThread
    void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthMillis) {
        MediaFormat format = MediaFormat.createVideoFormat((String)((Config)this.mConfig).mimeType, (int)((Config)this.mConfig).width, (int)((Config)this.mConfig).height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", ((Config)this.mConfig).bitRate);
        format.setInteger("frame-rate", ((Config)this.mConfig).frameRate);
        format.setInteger("frame-rate", 6);
        format.setInteger("i-frame-interval", 2);
        format.setInteger("rotation-degrees", ((Config)this.mConfig).rotation);
        try {
            this.mMediaCodec = MediaCodec.createEncoderByType((String)((Config)this.mConfig).mimeType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaCodec.configure(format, null, null, 1);
        this.mSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
    }

    @Override
    @EncoderThread
    void onStart() {
        this.mFrameNum = 0;
    }

    @Override
    @EncoderThread
    void onStop() {
        this.mFrameNum = -1;
        this.signalEndOfInputStream();
        this.drainOutput(true);
    }

    @Override
    int getEncodedBitRate() {
        return ((Config)this.mConfig).bitRate;
    }

    static class Config {
        int width;
        int height;
        int bitRate;
        int frameRate;
        int rotation;
        String mimeType;

        Config(int width, int height, int bitRate, int frameRate, int rotation, String mimeType) {
            this.width = width;
            this.height = height;
            this.bitRate = bitRate;
            this.frameRate = frameRate;
            this.rotation = rotation;
            this.mimeType = mimeType;
        }
    }
}

