/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.LayoutInflater;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.R;

class TextureCameraPreview
extends CameraPreview<TextureView, SurfaceTexture> {
    private View mRootView;

    TextureCameraPreview(@NonNull Context context, @NonNull ViewGroup parent, @Nullable CameraPreview.SurfaceCallback callback) {
        super(context, parent, callback);
    }

    @Override
    @NonNull
    protected TextureView onCreateView(@NonNull Context context, @NonNull ViewGroup parent) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.cameraview_texture_view, parent, false);
        parent.addView(root, 0);
        TextureView texture = (TextureView)root.findViewById(R.id.texture_view);
        texture.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                TextureCameraPreview.this.dispatchOnOutputSurfaceAvailable(width, height);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                TextureCameraPreview.this.dispatchOnOutputSurfaceSizeChanged(width, height);
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                TextureCameraPreview.this.dispatchOnOutputSurfaceDestroyed();
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        this.mRootView = root;
        return texture;
    }

    @Override
    @NonNull
    View getRootView() {
        return this.mRootView;
    }

    @Override
    @NonNull
    Class<SurfaceTexture> getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    @NonNull
    SurfaceTexture getOutput() {
        return ((TextureView)this.getView()).getSurfaceTexture();
    }

    @Override
    @TargetApi(value=15)
    void setInputStreamSize(int width, int height, boolean wasFlipped) {
        super.setInputStreamSize(width, height, wasFlipped);
        if (((TextureView)this.getView()).getSurfaceTexture() != null) {
            ((TextureView)this.getView()).getSurfaceTexture().setDefaultBufferSize(width, height);
        }
    }

    @Override
    boolean supportsCropping() {
        return true;
    }

    @Override
    protected void crop() {
        this.mCropTask.start();
        ((TextureView)this.getView()).post(new Runnable(){

            @Override
            public void run() {
                if (TextureCameraPreview.this.mInputStreamHeight == 0 || TextureCameraPreview.this.mInputStreamWidth == 0 || TextureCameraPreview.this.mOutputSurfaceHeight == 0 || TextureCameraPreview.this.mOutputSurfaceWidth == 0) {
                    TextureCameraPreview.this.mCropTask.end(null);
                    return;
                }
                float scaleX = 1.0f;
                float scaleY = 1.0f;
                AspectRatio current = AspectRatio.of(TextureCameraPreview.this.mOutputSurfaceWidth, TextureCameraPreview.this.mOutputSurfaceHeight);
                AspectRatio target = AspectRatio.of(TextureCameraPreview.this.mInputStreamWidth, TextureCameraPreview.this.mInputStreamHeight);
                if (current.toFloat() >= target.toFloat()) {
                    scaleY = current.toFloat() / target.toFloat();
                } else {
                    scaleX = target.toFloat() / current.toFloat();
                }
                ((TextureView)TextureCameraPreview.this.getView()).setScaleX(scaleX);
                ((TextureView)TextureCameraPreview.this.getView()).setScaleY(scaleY);
                TextureCameraPreview.this.mCropping = scaleX > 1.02f || scaleY > 1.02f;
                CameraPreview.LOG.i("crop:", "applied scaleX=", Float.valueOf(scaleX));
                CameraPreview.LOG.i("crop:", "applied scaleY=", Float.valueOf(scaleY));
                TextureCameraPreview.this.mCropTask.end(null);
            }
        });
    }
}

