/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.R;

class SurfaceCameraPreview
extends CameraPreview<SurfaceView, SurfaceHolder> {
    private static final CameraLogger LOG = CameraLogger.create(SurfaceCameraPreview.class.getSimpleName());
    private boolean mDispatched;
    private View mRootView;

    SurfaceCameraPreview(@NonNull Context context, @NonNull ViewGroup parent, @Nullable CameraPreview.SurfaceCallback callback) {
        super(context, parent, callback);
    }

    @Override
    @NonNull
    protected SurfaceView onCreateView(@NonNull Context context, @NonNull ViewGroup parent) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.cameraview_surface_view, parent, false);
        parent.addView(root, 0);
        SurfaceView surfaceView = (SurfaceView)root.findViewById(R.id.surface_view);
        SurfaceHolder holder = surfaceView.getHolder();
        holder.setType(3);
        holder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                LOG.i("callback:", "surfaceChanged", "w:", width, "h:", height, "dispatched:", SurfaceCameraPreview.this.mDispatched);
                if (!SurfaceCameraPreview.this.mDispatched) {
                    SurfaceCameraPreview.this.dispatchOnOutputSurfaceAvailable(width, height);
                    SurfaceCameraPreview.this.mDispatched = true;
                } else {
                    SurfaceCameraPreview.this.dispatchOnOutputSurfaceSizeChanged(width, height);
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                LOG.i("callback:", "surfaceDestroyed");
                SurfaceCameraPreview.this.dispatchOnOutputSurfaceDestroyed();
                SurfaceCameraPreview.this.mDispatched = false;
            }
        });
        this.mRootView = root;
        return surfaceView;
    }

    @Override
    @NonNull
    View getRootView() {
        return this.mRootView;
    }

    @Override
    @NonNull
    SurfaceHolder getOutput() {
        return ((SurfaceView)this.getView()).getHolder();
    }

    @Override
    @NonNull
    Class<SurfaceHolder> getOutputClass() {
        return SurfaceHolder.class;
    }
}

