/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.Camera1;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.CropHelper;
import com.otaliastudios.cameraview.EglCore;
import com.otaliastudios.cameraview.EglViewport;
import com.otaliastudios.cameraview.EglWindowSurface;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.GlCameraPreview;
import com.otaliastudios.cameraview.PictureRecorder;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.RendererThread;
import com.otaliastudios.cameraview.RotationHelper;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

class SnapshotPictureRecorder
extends PictureRecorder {
    private static final String TAG = SnapshotPictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private Camera1 mController;
    private Camera mCamera;
    private CameraPreview mPreview;
    private AspectRatio mOutputRatio;
    private Size mSensorPreviewSize;
    private int mFormat;

    SnapshotPictureRecorder(@NonNull PictureResult stub, @NonNull Camera1 controller, @NonNull Camera camera, @NonNull AspectRatio outputRatio) {
        super(stub, controller);
        this.mController = controller;
        this.mPreview = controller.mPreview;
        this.mCamera = camera;
        this.mOutputRatio = outputRatio;
        this.mFormat = this.mController.mPreviewFormat;
        this.mSensorPreviewSize = this.mController.mPreviewSize;
    }

    @Override
    void take() {
        if (this.mPreview instanceof GlCameraPreview) {
            this.takeGl((GlCameraPreview)this.mPreview);
        } else {
            this.takeLegacy();
        }
    }

    @SuppressLint(value={"NewApi"})
    private void takeGl(final @NonNull GlCameraPreview preview) {
        preview.addRendererFrameCallback(new GlCameraPreview.RendererFrameCallback(){
            int mTextureId;
            SurfaceTexture mSurfaceTexture;
            float[] mTransform;

            @Override
            @RendererThread
            public void onRendererTextureCreated(int textureId) {
                this.mTextureId = textureId;
                this.mSurfaceTexture = new SurfaceTexture(this.mTextureId, true);
                Rect crop = CropHelper.computeCrop(SnapshotPictureRecorder.this.mResult.size, SnapshotPictureRecorder.this.mOutputRatio);
                SnapshotPictureRecorder.this.mResult.size = new Size(crop.width(), crop.height());
                this.mSurfaceTexture.setDefaultBufferSize(SnapshotPictureRecorder.this.mResult.size.getWidth(), SnapshotPictureRecorder.this.mResult.size.getHeight());
                this.mTransform = new float[16];
            }

            @Override
            @RendererThread
            public void onRendererFrame(SurfaceTexture surfaceTexture, final float scaleX, final float scaleY) {
                preview.removeRendererFrameCallback(this);
                EGLContext eglContext = EGL14.eglGetCurrentContext();
                final EglCore core = new EglCore(eglContext, 1);
                WorkerHandler.run(new Runnable(){

                    @Override
                    public void run() {
                        EglWindowSurface surface = new EglWindowSurface(core, mSurfaceTexture);
                        surface.makeCurrent();
                        EglViewport viewport = new EglViewport();
                        mSurfaceTexture.updateTexImage();
                        mSurfaceTexture.getTransformMatrix(mTransform);
                        boolean flip = SnapshotPictureRecorder.this.mController.flip(1, 0);
                        float realScaleX = flip ? scaleY : scaleX;
                        float realScaleY = flip ? scaleX : scaleY;
                        float scaleTranslX = (1.0f - realScaleX) / 2.0f;
                        float scaleTranslY = (1.0f - realScaleY) / 2.0f;
                        Matrix.translateM((float[])mTransform, (int)0, (float)scaleTranslX, (float)scaleTranslY, (float)0.0f);
                        Matrix.scaleM((float[])mTransform, (int)0, (float)realScaleX, (float)realScaleY, (float)1.0f);
                        LOG.w("Recording frame. Rotation:", SnapshotPictureRecorder.this.mResult.rotation, "Actual:", -SnapshotPictureRecorder.this.mResult.rotation);
                        int rotation = -SnapshotPictureRecorder.this.mResult.rotation;
                        SnapshotPictureRecorder.this.mResult.rotation = 0;
                        Matrix.translateM((float[])mTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
                        Matrix.rotateM((float[])mTransform, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
                        if (SnapshotPictureRecorder.this.mResult.facing == Facing.FRONT) {
                            Matrix.scaleM((float[])mTransform, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
                        }
                        Matrix.translateM((float[])mTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
                        viewport.drawFrame(mTextureId, mTransform);
                        SnapshotPictureRecorder.this.mResult.data = surface.saveFrameTo(Bitmap.CompressFormat.JPEG);
                        SnapshotPictureRecorder.this.mResult.format = 0;
                        mSurfaceTexture.releaseTexImage();
                        surface.release();
                        viewport.release();
                        mSurfaceTexture.release();
                        core.release();
                        SnapshotPictureRecorder.this.dispatchResult();
                    }
                });
            }
        });
    }

    private void takeLegacy() {
        this.mCamera.setOneShotPreviewCallback(new Camera.PreviewCallback(){

            public void onPreviewFrame(final @NonNull byte[] yuv, Camera camera) {
                SnapshotPictureRecorder.this.dispatchOnShutter(false);
                final int sensorToOutput = SnapshotPictureRecorder.this.mResult.rotation;
                final Size outputSize = SnapshotPictureRecorder.this.mResult.size;
                WorkerHandler.run(new Runnable(){

                    @Override
                    public void run() {
                        byte[] data = RotationHelper.rotate(yuv, SnapshotPictureRecorder.this.mSensorPreviewSize, sensorToOutput);
                        YuvImage yuv2 = new YuvImage(data, SnapshotPictureRecorder.this.mFormat, outputSize.getWidth(), outputSize.getHeight(), null);
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        Rect outputRect = CropHelper.computeCrop(outputSize, SnapshotPictureRecorder.this.mOutputRatio);
                        yuv2.compressToJpeg(outputRect, 90, (OutputStream)stream);
                        data = stream.toByteArray();
                        SnapshotPictureRecorder.this.mResult.data = data;
                        SnapshotPictureRecorder.this.mResult.size = new Size(outputRect.width(), outputRect.height());
                        SnapshotPictureRecorder.this.mResult.rotation = 0;
                        SnapshotPictureRecorder.this.mResult.format = 0;
                        SnapshotPictureRecorder.this.dispatchResult();
                    }
                });
                camera.setPreviewCallbackWithBuffer(null);
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)SnapshotPictureRecorder.this.mController);
                ((SnapshotPictureRecorder)SnapshotPictureRecorder.this).mController.mFrameManager.allocate(ImageFormat.getBitsPerPixel((int)SnapshotPictureRecorder.this.mFormat), ((SnapshotPictureRecorder)SnapshotPictureRecorder.this).mController.mPreviewSize);
            }
        });
    }

    @Override
    protected void dispatchResult() {
        this.mController = null;
        this.mCamera = null;
        this.mOutputRatio = null;
        this.mFormat = 0;
        this.mSensorPreviewSize = null;
        super.dispatchResult();
    }
}

