/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.NonNull;

public class Size
implements Comparable<Size> {
    private final int mWidth;
    private final int mHeight;

    Size(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    Size flip() {
        return new Size(this.mHeight, this.mWidth);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof Size) {
            Size size = (Size)o;
            return this.mWidth == size.mWidth && this.mHeight == size.mHeight;
        }
        return false;
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }

    public int hashCode() {
        return this.mHeight ^ (this.mWidth << 16 | this.mWidth >>> 16);
    }

    @Override
    public int compareTo(@NonNull Size another) {
        return this.mWidth * this.mHeight - another.mWidth * another.mHeight;
    }
}

