/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import java.util.concurrent.LinkedBlockingQueue;

class Pool<T> {
    private static final String TAG = Pool.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private int maxPoolSize;
    private int activeCount;
    private LinkedBlockingQueue<T> mQueue;
    private Factory<T> factory;

    Pool(int maxPoolSize, Factory<T> factory) {
        this.maxPoolSize = maxPoolSize;
        this.mQueue = new LinkedBlockingQueue(maxPoolSize);
        this.factory = factory;
    }

    boolean canGet() {
        return this.count() < this.maxPoolSize;
    }

    @Nullable
    T get() {
        T buffer = this.mQueue.poll();
        if (buffer != null) {
            ++this.activeCount;
            LOG.v("GET: Reusing recycled item.", this);
            return buffer;
        }
        if (!this.canGet()) {
            LOG.v("GET: Returning null. Too much items requested.", this);
            return null;
        }
        ++this.activeCount;
        LOG.v("GET: Creating a new item.", this);
        return this.factory.create();
    }

    void recycle(@NonNull T item) {
        LOG.v("RECYCLE: Recycling item.", this);
        if (--this.activeCount < 0) {
            throw new IllegalStateException("Trying to recycle an item which makes activeCount < 0.This means that this or some previous items being recycled were not coming from this pool, or some item was recycled more than once. " + this);
        }
        if (!this.mQueue.offer(item)) {
            throw new IllegalStateException("Trying to recycle an item while the queue is full. This means that this or some previous items being recycled were not coming from this pool, or some item was recycled more than once. " + this);
        }
    }

    @NonNull
    public String toString() {
        return this.getClass().getSimpleName() + " -- count:" + this.count() + ", active:" + this.activeCount() + ", cached:" + this.cachedCount();
    }

    final int count() {
        return this.activeCount() + this.cachedCount();
    }

    final int activeCount() {
        return this.activeCount;
    }

    final int cachedCount() {
        return this.mQueue.size();
    }

    @CallSuper
    void clear() {
        this.mQueue.clear();
    }

    static interface Factory<T> {
        public T create();
    }
}

