/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.PictureResult;

abstract class PictureRecorder {
    PictureResult mResult;
    PictureResultListener mListener;

    PictureRecorder(@NonNull PictureResult stub, @Nullable PictureResultListener listener) {
        this.mResult = stub;
        this.mListener = listener;
    }

    abstract void take();

    protected void dispatchOnShutter(boolean didPlaySound) {
        if (this.mListener != null) {
            this.mListener.onPictureShutter(didPlaySound);
        }
    }

    protected void dispatchResult() {
        if (this.mListener != null) {
            this.mListener.onPictureResult(this.mResult);
            this.mListener = null;
            this.mResult = null;
        }
    }

    static interface PictureResultListener {
        public void onPictureShutter(boolean var1);

        public void onPictureResult(@Nullable PictureResult var1);
    }
}

