/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.AudioMediaEncoder;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.MediaEncoder;
import com.otaliastudios.cameraview.OutputBuffer;
import com.otaliastudios.cameraview.OutputBufferPool;
import com.otaliastudios.cameraview.VideoMediaEncoder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

@RequiresApi(api=18)
class MediaEncoderEngine {
    private static final String TAG = MediaEncoderEngine.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    static final int STOP_BY_USER = 0;
    static final int STOP_BY_MAX_DURATION = 1;
    static final int STOP_BY_MAX_SIZE = 2;
    private ArrayList<MediaEncoder> mEncoders;
    private MediaMuxer mMediaMuxer;
    private int mStartedEncodersCount;
    private int mStoppedEncodersCount;
    private boolean mMediaMuxerStarted;
    private Controller mController;
    private Listener mListener;
    private int mStopReason = 0;
    private int mPossibleStopReason;
    private final Object mControllerLock = new Object();

    MediaEncoderEngine(@NonNull File file, @NonNull VideoMediaEncoder videoEncoder, @Nullable AudioMediaEncoder audioEncoder, int maxDuration, long maxSize, @Nullable Listener listener) {
        this.mListener = listener;
        this.mController = new Controller();
        this.mEncoders = new ArrayList();
        this.mEncoders.add(videoEncoder);
        if (audioEncoder != null) {
            this.mEncoders.add(audioEncoder);
        }
        try {
            this.mMediaMuxer = new MediaMuxer(file.toString(), 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mStartedEncodersCount = 0;
        this.mMediaMuxerStarted = false;
        this.mStoppedEncodersCount = 0;
        int bitRate = 0;
        for (MediaEncoder encoder : this.mEncoders) {
            bitRate += encoder.getEncodedBitRate();
        }
        int bytePerSecond = bitRate / 8;
        long sizeMaxDuration = maxSize / (long)bytePerSecond * 1000L;
        long finalMaxDuration = Long.MAX_VALUE;
        if (maxSize > 0L && maxDuration > 0) {
            this.mPossibleStopReason = sizeMaxDuration < (long)maxDuration ? 2 : 1;
            finalMaxDuration = Math.min(sizeMaxDuration, (long)maxDuration);
        } else if (maxSize > 0L) {
            this.mPossibleStopReason = 2;
            finalMaxDuration = sizeMaxDuration;
        } else if (maxDuration > 0) {
            this.mPossibleStopReason = 1;
            finalMaxDuration = maxDuration;
        }
        LOG.w("Computed a max duration of", Float.valueOf((float)finalMaxDuration / 1000.0f));
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.prepare(this.mController, finalMaxDuration);
        }
    }

    final void start() {
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.start();
        }
    }

    final void notify(String event, Object data) {
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.notify(event, data);
        }
    }

    final void stop() {
        for (MediaEncoder encoder : this.mEncoders) {
            encoder.stop();
        }
    }

    private void release() {
        Exception error = null;
        if (this.mMediaMuxer != null) {
            try {
                this.mMediaMuxer.stop();
                this.mMediaMuxer.release();
            }
            catch (Exception e) {
                error = e;
            }
            this.mMediaMuxer = null;
        }
        if (this.mListener != null) {
            this.mListener.onEncoderStop(this.mStopReason, error);
            this.mListener = null;
        }
        this.mStopReason = 0;
        this.mStartedEncodersCount = 0;
        this.mStoppedEncodersCount = 0;
        this.mMediaMuxerStarted = false;
    }

    @NonNull
    VideoMediaEncoder getVideoEncoder() {
        return (VideoMediaEncoder)this.mEncoders.get(0);
    }

    @Nullable
    AudioMediaEncoder getAudioEncoder() {
        if (this.mEncoders.size() > 1) {
            return (AudioMediaEncoder)this.mEncoders.get(1);
        }
        return null;
    }

    static interface Listener {
        @EncoderThread
        public void onEncoderStop(int var1, @Nullable Exception var2);
    }

    class Controller {
        Controller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int requestStart(MediaFormat format) {
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                if (MediaEncoderEngine.this.mMediaMuxerStarted) {
                    throw new IllegalStateException("Trying to start but muxer started already");
                }
                int track = MediaEncoderEngine.this.mMediaMuxer.addTrack(format);
                LOG.w("Controller:", "Assigned track", track, "to format", format.getString("mime"));
                if (++MediaEncoderEngine.this.mStartedEncodersCount == MediaEncoderEngine.this.mEncoders.size()) {
                    MediaEncoderEngine.this.mMediaMuxer.start();
                    MediaEncoderEngine.this.mMediaMuxerStarted = true;
                }
                return track;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isStarted() {
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                return MediaEncoderEngine.this.mMediaMuxerStarted;
            }
        }

        void write(OutputBufferPool pool, OutputBuffer buffer) {
            if (!MediaEncoderEngine.this.mMediaMuxerStarted) {
                throw new IllegalStateException("Trying to write before muxer started");
            }
            LOG.v("Writing for track", buffer.trackIndex, ". Presentation:", buffer.info.presentationTimeUs);
            MediaEncoderEngine.this.mMediaMuxer.writeSampleData(buffer.trackIndex, buffer.data, buffer.info);
            pool.recycle(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestStop(int track) {
            LOG.i("RequestStop was called for track", track);
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                if (--MediaEncoderEngine.this.mStartedEncodersCount == 0) {
                    MediaEncoderEngine.this.mStopReason = MediaEncoderEngine.this.mPossibleStopReason;
                    MediaEncoderEngine.this.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestRelease(int track) {
            LOG.i("requestRelease was called for track", track);
            Object object = MediaEncoderEngine.this.mControllerLock;
            synchronized (object) {
                if (++MediaEncoderEngine.this.mStoppedEncodersCount == MediaEncoderEngine.this.mEncoders.size()) {
                    MediaEncoderEngine.this.release();
                }
            }
        }
    }
}

