/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.EncoderThread;
import com.otaliastudios.cameraview.InputBuffer;
import com.otaliastudios.cameraview.MediaCodecBuffers;
import com.otaliastudios.cameraview.MediaEncoderEngine;
import com.otaliastudios.cameraview.OutputBuffer;
import com.otaliastudios.cameraview.OutputBufferPool;
import com.otaliastudios.cameraview.WorkerHandler;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
abstract class MediaEncoder {
    private static final String TAG = MediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int INPUT_TIMEOUT_US = 0;
    private static final int OUTPUT_TIMEOUT_US = 0;
    protected MediaCodec mMediaCodec;
    protected WorkerHandler mWorker;
    private MediaEncoderEngine.Controller mController;
    private int mTrackIndex;
    private OutputBufferPool mOutputBufferPool;
    private MediaCodec.BufferInfo mBufferInfo;
    private MediaCodecBuffers mBuffers;
    private long mMaxLengthMillis;
    private boolean mMaxLengthReached;
    private long mStartPresentationTimeUs = Long.MIN_VALUE;
    private long mLastPresentationTimeUs = 0L;

    MediaEncoder() {
    }

    @NonNull
    abstract String getName();

    final void prepare(final @NonNull MediaEncoderEngine.Controller controller, final long maxLengthMillis) {
        this.mController = controller;
        this.mBufferInfo = new MediaCodec.BufferInfo();
        this.mMaxLengthMillis = maxLengthMillis;
        this.mWorker = WorkerHandler.get(this.getName());
        LOG.i(this.getName(), "Prepare was called. Posting.");
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                LOG.i(MediaEncoder.this.getName(), "Prepare was called. Executing.");
                MediaEncoder.this.onPrepare(controller, maxLengthMillis);
            }
        });
    }

    final void start() {
        LOG.i(this.getName(), "Start was called. Posting.");
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                LOG.i(MediaEncoder.this.getName(), "Start was called. Executing.");
                MediaEncoder.this.onStart();
            }
        });
    }

    final void notify(final @NonNull String event, final @Nullable Object data) {
        LOG.i(this.getName(), "Notify was called. Posting.");
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                LOG.i(MediaEncoder.this.getName(), "Notify was called. Executing.");
                MediaEncoder.this.onEvent(event, data);
            }
        });
    }

    final void stop() {
        LOG.i(this.getName(), "Stop was called. Posting.");
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                LOG.i(MediaEncoder.this.getName(), "Stop was called. Executing.");
                MediaEncoder.this.onStop();
            }
        });
    }

    @EncoderThread
    abstract void onPrepare(@NonNull MediaEncoderEngine.Controller var1, long var2);

    @EncoderThread
    abstract void onStart();

    @EncoderThread
    abstract void onEvent(@NonNull String var1, @Nullable Object var2);

    @EncoderThread
    abstract void onStop();

    private void release() {
        LOG.w("Subclass", this.getName(), "Notified that it is released.");
        this.mController.requestRelease(this.mTrackIndex);
        this.mMediaCodec.stop();
        this.mMediaCodec.release();
        this.mMediaCodec = null;
        this.mOutputBufferPool.clear();
        this.mOutputBufferPool = null;
        this.mBuffers = null;
        this.onRelease();
    }

    abstract void onRelease();

    protected boolean tryAcquireInputBuffer(@NonNull InputBuffer holder) {
        int inputBufferIndex;
        if (this.mBuffers == null) {
            this.mBuffers = new MediaCodecBuffers(this.mMediaCodec);
        }
        if ((inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(0L)) < 0) {
            return false;
        }
        holder.index = inputBufferIndex;
        holder.data = this.mBuffers.getInputBuffer(inputBufferIndex);
        return true;
    }

    protected void acquireInputBuffer(@NonNull InputBuffer holder) {
        while (!this.tryAcquireInputBuffer(holder)) {
        }
    }

    protected void encodeInputBuffer(InputBuffer buffer) {
        LOG.w("ENCODING:", this.getName(), "Buffer:", buffer.index, "Bytes:", buffer.length, "Presentation:", buffer.timestamp);
        if (buffer.isEndOfStream) {
            this.mMediaCodec.queueInputBuffer(buffer.index, 0, 0, buffer.timestamp, 4);
        } else {
            this.mMediaCodec.queueInputBuffer(buffer.index, 0, buffer.length, buffer.timestamp, 0);
        }
    }

    protected void signalEndOfInputStream() {
        this.mMediaCodec.signalEndOfInputStream();
    }

    @SuppressLint(value={"LogNotTimber"})
    protected void drainOutput(boolean drainAll) {
        block11: {
            LOG.w("DRAINING:", this.getName(), "EOS:", drainAll);
            if (this.mMediaCodec == null) {
                LOG.e("drain() was called before prepare() or after releasing.");
                return;
            }
            if (this.mBuffers == null) {
                this.mBuffers = new MediaCodecBuffers(this.mMediaCodec);
            }
            while (true) {
                boolean isCodecConfig;
                int encoderStatus;
                if ((encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 0L)) == -1) {
                    if (drainAll) continue;
                    break block11;
                }
                if (encoderStatus == -3) {
                    this.mBuffers.onOutputBuffersChanged();
                    continue;
                }
                if (encoderStatus == -2) {
                    if (this.mController.isStarted()) {
                        throw new RuntimeException("MediaFormat changed twice.");
                    }
                    MediaFormat newFormat = this.mMediaCodec.getOutputFormat();
                    this.mTrackIndex = this.mController.requestStart(newFormat);
                    this.mOutputBufferPool = new OutputBufferPool(this.mTrackIndex);
                    continue;
                }
                if (encoderStatus < 0) {
                    LOG.e("Unexpected result from dequeueOutputBuffer: " + encoderStatus);
                    continue;
                }
                ByteBuffer encodedData = this.mBuffers.getOutputBuffer(encoderStatus);
                boolean bl = isCodecConfig = (this.mBufferInfo.flags & 2) != 0;
                if (!isCodecConfig && this.mController.isStarted() && this.mBufferInfo.size != 0) {
                    encodedData.position(this.mBufferInfo.offset);
                    encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                    if (this.mStartPresentationTimeUs == Long.MIN_VALUE) {
                        this.mStartPresentationTimeUs = this.mBufferInfo.presentationTimeUs;
                    }
                    this.mLastPresentationTimeUs = this.mBufferInfo.presentationTimeUs;
                    LOG.i("DRAINING:", this.getName(), "Dispatching write(). Presentation:", this.mBufferInfo.presentationTimeUs);
                    OutputBuffer buffer = (OutputBuffer)this.mOutputBufferPool.get();
                    buffer.info = this.mBufferInfo;
                    buffer.trackIndex = this.mTrackIndex;
                    buffer.data = encodedData;
                    this.mController.write(this.mOutputBufferPool, buffer);
                }
                this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
                if (!drainAll && !this.mMaxLengthReached && this.mStartPresentationTimeUs != Long.MIN_VALUE && this.mLastPresentationTimeUs - this.mStartPresentationTimeUs > this.mMaxLengthMillis * 1000L) {
                    LOG.w("DRAINING: Reached maxLength! mLastPresentationTimeUs:", this.mLastPresentationTimeUs, "mStartPresentationTimeUs:", this.mStartPresentationTimeUs, "mMaxLengthUs:", this.mMaxLengthMillis * 1000L);
                    this.mMaxLengthReached = true;
                    this.mController.requestStop(this.mTrackIndex);
                    break block11;
                }
                if ((this.mBufferInfo.flags & 4) != 0) break;
            }
            LOG.w("DRAINING:", this.getName(), "Dispatching release().");
            this.release();
        }
    }

    abstract int getEncodedBitRate();
}

