/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.media.MediaCodec;
import android.os.Build;
import java.nio.ByteBuffer;

class MediaCodecBuffers {
    private final MediaCodec mMediaCodec;
    private final ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;

    MediaCodecBuffers(MediaCodec mediaCodec) {
        this.mMediaCodec = mediaCodec;
        if (Build.VERSION.SDK_INT < 21) {
            this.mInputBuffers = mediaCodec.getInputBuffers();
            this.mOutputBuffers = mediaCodec.getOutputBuffers();
        } else {
            this.mOutputBuffers = null;
            this.mInputBuffers = null;
        }
    }

    public ByteBuffer getInputBuffer(int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mMediaCodec.getInputBuffer(index);
        }
        ByteBuffer buffer = this.mInputBuffers[index];
        buffer.clear();
        return buffer;
    }

    public ByteBuffer getOutputBuffer(int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mMediaCodec.getOutputBuffer(index);
        }
        return this.mOutputBuffers[index];
    }

    public void onOutputBuffersChanged() {
        if (Build.VERSION.SDK_INT < 21) {
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
        }
    }
}

