/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.EglBaseSurface;
import com.otaliastudios.cameraview.EglCore;

@RequiresApi(api=18)
class EglWindowSurface
extends EglBaseSurface {
    private Surface mSurface;
    private boolean mReleaseSurface;

    public EglWindowSurface(EglCore eglCore, Surface surface, boolean releaseSurface) {
        super(eglCore);
        this.createWindowSurface(surface);
        this.mSurface = surface;
        this.mReleaseSurface = releaseSurface;
    }

    public EglWindowSurface(EglCore eglCore, SurfaceTexture surfaceTexture) {
        super(eglCore);
        this.createWindowSurface(surfaceTexture);
    }

    public EglWindowSurface(EglCore eglCore, Surface surface) {
        super(eglCore);
        this.createWindowSurface(surface);
    }

    public void release() {
        this.releaseEglSurface();
        if (this.mSurface != null) {
            if (this.mReleaseSurface) {
                this.mSurface.release();
            }
            this.mSurface = null;
        }
    }

    public void recreate(EglCore newEglCore) {
        if (this.mSurface == null) {
            throw new RuntimeException("not yet implemented for SurfaceTexture");
        }
        this.mEglCore = newEglCore;
        this.createWindowSurface(this.mSurface);
    }
}

