/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.Task;

abstract class CameraPreview<T extends View, Output> {
    protected static final CameraLogger LOG = CameraLogger.create(CameraPreview.class.getSimpleName());
    Task<Void> mCropTask = new Task();
    private SurfaceCallback mSurfaceCallback;
    private T mView;
    protected boolean mCropping;
    protected int mOutputSurfaceWidth;
    protected int mOutputSurfaceHeight;
    protected int mInputStreamWidth;
    protected int mInputStreamHeight;
    protected boolean mInputFlipped;

    CameraPreview(@NonNull Context context, @NonNull ViewGroup parent, @Nullable SurfaceCallback callback) {
        this.mView = this.onCreateView(context, parent);
        this.mSurfaceCallback = callback;
    }

    @NonNull
    protected abstract T onCreateView(@NonNull Context var1, @NonNull ViewGroup var2);

    @NonNull
    final T getView() {
        return this.mView;
    }

    @NonNull
    abstract View getRootView();

    @NonNull
    abstract Class<Output> getOutputClass();

    @NonNull
    abstract Output getOutput();

    void setInputStreamSize(int width, int height, boolean wasFlipped) {
        LOG.i("setInputStreamSize:", "desiredW=", width, "desiredH=", height);
        this.mInputStreamWidth = width;
        this.mInputStreamHeight = height;
        this.mInputFlipped = wasFlipped;
        if (this.mInputStreamWidth > 0 && this.mInputStreamHeight > 0) {
            this.crop();
        }
    }

    @NonNull
    final Size getInputStreamSize() {
        return new Size(this.mInputStreamWidth, this.mInputStreamHeight);
    }

    @NonNull
    final Size getOutputSurfaceSize() {
        return new Size(this.mOutputSurfaceWidth, this.mOutputSurfaceHeight);
    }

    final void setSurfaceCallback(@NonNull SurfaceCallback callback) {
        this.mSurfaceCallback = callback;
        if (this.mOutputSurfaceWidth != 0 || this.mOutputSurfaceHeight != 0) {
            this.mSurfaceCallback.onSurfaceAvailable();
        }
    }

    protected final void dispatchOnOutputSurfaceAvailable(int width, int height) {
        LOG.i("dispatchOnOutputSurfaceAvailable:", "w=", width, "h=", height);
        this.mOutputSurfaceWidth = width;
        this.mOutputSurfaceHeight = height;
        if (this.mOutputSurfaceWidth > 0 && this.mOutputSurfaceHeight > 0) {
            this.crop();
        }
        this.mSurfaceCallback.onSurfaceAvailable();
    }

    protected final void dispatchOnOutputSurfaceSizeChanged(int width, int height) {
        LOG.i("dispatchOnOutputSurfaceSizeChanged:", "w=", width, "h=", height);
        if (width != this.mOutputSurfaceWidth || height != this.mOutputSurfaceHeight) {
            this.mOutputSurfaceWidth = width;
            this.mOutputSurfaceHeight = height;
            if (width > 0 && height > 0) {
                this.crop();
            }
            this.mSurfaceCallback.onSurfaceChanged();
        }
    }

    protected final void dispatchOnOutputSurfaceDestroyed() {
        this.mOutputSurfaceWidth = 0;
        this.mOutputSurfaceHeight = 0;
        this.mSurfaceCallback.onSurfaceDestroyed();
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    final boolean hasSurface() {
        return this.mOutputSurfaceWidth > 0 && this.mOutputSurfaceHeight > 0;
    }

    protected void crop() {
        this.mCropTask.start();
        this.mCropTask.end(null);
    }

    boolean supportsCropping() {
        return false;
    }

    boolean isCropping() {
        return this.mCropping;
    }

    static interface SurfaceCallback {
        public void onSurfaceAvailable();

        public void onSurfaceChanged();

        public void onSurfaceDestroyed();
    }
}

