/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.Control;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.GestureAction;
import com.otaliastudios.cameraview.Grid;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.Mapper;
import com.otaliastudios.cameraview.Mapper1;
import com.otaliastudios.cameraview.Mode;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.VideoCodec;
import com.otaliastudios.cameraview.WhiteBalance;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CameraOptions {
    private Set<WhiteBalance> supportedWhiteBalance = new HashSet<WhiteBalance>(5);
    private Set<Facing> supportedFacing = new HashSet<Facing>(2);
    private Set<Flash> supportedFlash = new HashSet<Flash>(4);
    private Set<Hdr> supportedHdr = new HashSet<Hdr>(2);
    private Set<Size> supportedPictureSizes = new HashSet<Size>(15);
    private Set<Size> supportedVideoSizes = new HashSet<Size>(5);
    private Set<AspectRatio> supportedPictureAspectRatio = new HashSet<AspectRatio>(4);
    private Set<AspectRatio> supportedVideoAspectRatio = new HashSet<AspectRatio>(3);
    private boolean zoomSupported;
    private boolean exposureCorrectionSupported;
    private float exposureCorrectionMinValue;
    private float exposureCorrectionMaxValue;
    private boolean autoFocusSupported;

    CameraOptions(@NonNull Camera.Parameters params, boolean flipSizes) {
        Object value;
        Mapper1 mapper = new Mapper1();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            value = ((Mapper)mapper).unmapFacing(cameraInfo.facing);
            if (value == null) continue;
            this.supportedFacing.add((Facing)value);
        }
        List strings = params.getSupportedWhiteBalance();
        if (strings != null) {
            for (String string : strings) {
                value = ((Mapper)mapper).unmapWhiteBalance(string);
                if (value == null) continue;
                this.supportedWhiteBalance.add((WhiteBalance)value);
            }
        }
        this.supportedFlash.add(Flash.OFF);
        strings = params.getSupportedFlashModes();
        if (strings != null) {
            for (String string : strings) {
                value = ((Mapper)mapper).unmapFlash(string);
                if (value == null) continue;
                this.supportedFlash.add((Flash)value);
            }
        }
        this.supportedHdr.add(Hdr.OFF);
        strings = params.getSupportedSceneModes();
        if (strings != null) {
            for (String string : strings) {
                value = ((Mapper)mapper).unmapHdr(string);
                if (value == null) continue;
                this.supportedHdr.add((Hdr)value);
            }
        }
        this.zoomSupported = params.isZoomSupported();
        this.autoFocusSupported = params.getSupportedFocusModes().contains("auto");
        float step = params.getExposureCompensationStep();
        this.exposureCorrectionMinValue = (float)params.getMinExposureCompensation() * step;
        this.exposureCorrectionMaxValue = (float)params.getMaxExposureCompensation() * step;
        this.exposureCorrectionSupported = params.getMinExposureCompensation() != 0 || params.getMaxExposureCompensation() != 0;
        List sizes = params.getSupportedPictureSizes();
        for (Object size : sizes) {
            int width = flipSizes ? ((Camera.Size)size).height : ((Camera.Size)size).width;
            int height = flipSizes ? ((Camera.Size)size).width : ((Camera.Size)size).height;
            this.supportedPictureSizes.add(new Size(width, height));
            this.supportedPictureAspectRatio.add(AspectRatio.of(width, height));
        }
        List vsizes = params.getSupportedVideoSizes();
        if (vsizes != null) {
            for (Camera.Size size : vsizes) {
                int width = flipSizes ? size.height : size.width;
                int height = flipSizes ? size.width : size.height;
                this.supportedVideoSizes.add(new Size(width, height));
                this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
            }
        } else {
            List fallback = params.getSupportedPreviewSizes();
            for (Camera.Size size : fallback) {
                int width = flipSizes ? size.height : size.width;
                int height = flipSizes ? size.width : size.height;
                this.supportedVideoSizes.add(new Size(width, height));
                this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
            }
        }
    }

    @TargetApi(value=21)
    CameraOptions(@NonNull CameraCharacteristics params) {
    }

    public boolean supports(@NonNull Control control) {
        return this.getSupportedControls(control.getClass()).contains(control);
    }

    public boolean supports(@NonNull GestureAction action) {
        switch (action) {
            case FOCUS: 
            case FOCUS_WITH_MARKER: {
                return this.isAutoFocusSupported();
            }
            case CAPTURE: 
            case NONE: {
                return true;
            }
            case ZOOM: {
                return this.isZoomSupported();
            }
            case EXPOSURE_CORRECTION: {
                return this.isExposureCorrectionSupported();
            }
        }
        return false;
    }

    @NonNull
    public <T extends Control> Collection<T> getSupportedControls(@NonNull Class<T> controlClass) {
        if (controlClass.equals(Audio.class)) {
            return Arrays.asList(Audio.values());
        }
        if (controlClass.equals(Facing.class)) {
            return this.getSupportedFacing();
        }
        if (controlClass.equals(Flash.class)) {
            return this.getSupportedFlash();
        }
        if (controlClass.equals(Grid.class)) {
            return Arrays.asList(Grid.values());
        }
        if (controlClass.equals(Hdr.class)) {
            return this.getSupportedHdr();
        }
        if (controlClass.equals(Mode.class)) {
            return Arrays.asList(Mode.values());
        }
        if (controlClass.equals(VideoCodec.class)) {
            return Arrays.asList(VideoCodec.values());
        }
        if (controlClass.equals(WhiteBalance.class)) {
            return this.getSupportedWhiteBalance();
        }
        return Collections.emptyList();
    }

    @NonNull
    public Collection<Size> getSupportedPictureSizes() {
        return Collections.unmodifiableSet(this.supportedPictureSizes);
    }

    @NonNull
    public Collection<AspectRatio> getSupportedPictureAspectRatios() {
        return Collections.unmodifiableSet(this.supportedPictureAspectRatio);
    }

    @NonNull
    public Collection<Size> getSupportedVideoSizes() {
        return Collections.unmodifiableSet(this.supportedVideoSizes);
    }

    @NonNull
    public Collection<AspectRatio> getSupportedVideoAspectRatios() {
        return Collections.unmodifiableSet(this.supportedVideoAspectRatio);
    }

    @NonNull
    public Collection<Facing> getSupportedFacing() {
        return Collections.unmodifiableSet(this.supportedFacing);
    }

    @NonNull
    public Collection<Flash> getSupportedFlash() {
        return Collections.unmodifiableSet(this.supportedFlash);
    }

    @NonNull
    public Collection<WhiteBalance> getSupportedWhiteBalance() {
        return Collections.unmodifiableSet(this.supportedWhiteBalance);
    }

    @NonNull
    public Collection<Hdr> getSupportedHdr() {
        return Collections.unmodifiableSet(this.supportedHdr);
    }

    public boolean isZoomSupported() {
        return this.zoomSupported;
    }

    public boolean isAutoFocusSupported() {
        return this.autoFocusSupported;
    }

    public boolean isExposureCorrectionSupported() {
        return this.exposureCorrectionSupported;
    }

    public float getExposureCorrectionMinValue() {
        return this.exposureCorrectionMinValue;
    }

    public float getExposureCorrectionMaxValue() {
        return this.exposureCorrectionMaxValue;
    }
}

